/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import de.citec.scie.pdf.PreTextBlock;
import de.citec.scie.pdf.PreTextLine;

public class ParagraphEstimator {
    private static final double LINEENDTOL = 0.8;
    private static final double XTOL = 0.03;
    private static final double YTOL = 1.2;
    private final PreTextBlock block;
    private PreTextLine lastLine = null;

    public ParagraphEstimator(PreTextBlock block) {
        this.block = block;
    }

    public boolean isNewParagraph(PreTextLine line) {
        float thisLength;
        if (this.lastLine == null) {
            this.lastLine = line;
            return false;
        }
        float lastLength = this.lastLine.length();
        if ((double)lastLength < 0.8 * (double)(thisLength = line.length())) {
            this.lastLine = line;
            return true;
        }
        float normalizedDiff = (line.getX_start() - this.lastLine.getX_start()) / thisLength;
        if ((double)normalizedDiff > 0.03) {
            this.lastLine = line;
            return true;
        }
        if (!line.yHisto.getBackingMap().isEmpty() && !this.lastLine.yHisto.getBackingMap().isEmpty()) {
            float gap = line.yHisto.getMaxElement().floatValue() - this.lastLine.yHisto.getMaxElement().floatValue();
            if (!this.block.yDistHisto.getBackingMap().isEmpty() && (double)gap > 1.2 * (double)this.block.yDistHisto.getMaxElement().floatValue()) {
                this.lastLine = line;
                return true;
            }
            if (gap < 0.0f) {
                this.lastLine = line;
                return true;
            }
        }
        this.lastLine = line;
        return false;
    }
}

