/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf;

import java.util.HashMap;
import java.util.Map;

public class Histogramm<H> {
    private final HashMap<H, Integer> backingMap = new HashMap();

    public void addAll(Histogramm<H> otherHisto) {
        for (Map.Entry<H, Integer> otherEntry : otherHisto.backingMap.entrySet()) {
            int newValue = otherEntry.getValue();
            Integer thisValue = this.backingMap.get(otherEntry.getKey());
            if (thisValue != null) {
                newValue += thisValue.intValue();
            }
            this.backingMap.put(otherEntry.getKey(), newValue);
        }
    }

    public Integer addDataPoint(H datapoint) {
        int currentNum = this.getNumber(datapoint);
        return this.backingMap.put(datapoint, currentNum + 1);
    }

    public int getNumber(H datapoint) {
        Integer currentNum = this.backingMap.get(datapoint);
        if (currentNum == null) {
            return 0;
        }
        return currentNum;
    }

    public double getAverage() {
        if (this.backingMap.isEmpty()) {
            return 0.0;
        }
        H firstKey = this.backingMap.keySet().iterator().next();
        if (!(firstKey instanceof Number)) {
            throw new RuntimeException("Attempted to calculate average for non-numeric class!");
        }
        double weightedSum = 0.0;
        int normalization = 0;
        for (Map.Entry<H, Integer> mapEntry : this.backingMap.entrySet()) {
            Number numKey = (Number)mapEntry.getKey();
            double doubleKey = numKey.doubleValue();
            int occs = mapEntry.getValue();
            weightedSum += (double)occs * doubleKey;
            normalization += occs;
        }
        return weightedSum / (double)normalization;
    }

    public Map<H, Integer> getBackingMap() {
        return this.backingMap;
    }

    public H getMaxElement() {
        int currentMax = 0;
        H currentMaxElem = null;
        for (Map.Entry<H, Integer> mapEntry : this.backingMap.entrySet()) {
            if (mapEntry.getValue() <= currentMax) continue;
            currentMaxElem = mapEntry.getKey();
            currentMax = mapEntry.getValue();
        }
        return currentMaxElem;
    }
}

