/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.pdf.gui;

import de.citec.scie.pdf.PDFStructuredTextExtractor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class App {
    private static final String TITLE = "SCIE PDF Text Extractor";
    private static final String VERSION = "1.0.1";
    private static final MainWindow MAINWINDOW = new MainWindow();
    private static DefaultListModel<File> input = new DefaultListModel();
    private static File output = new File(".");

    public static void main(String[] args) {
        MAINWINDOW.start();
    }

    private static void process() {
        HashSet<File> actualFiles = new HashSet<File>();
        Enumeration<File> files = input.elements();
        while (files.hasMoreElements()) {
            File file = files.nextElement();
            if (file.isDirectory()) {
                for (File childFile : file.listFiles()) {
                    if (!childFile.getName().endsWith(".pdf")) continue;
                    actualFiles.add(childFile);
                }
                continue;
            }
            actualFiles.add(file);
        }
        float counter = 0.0f;
        float total = actualFiles.size();
        for (File file : actualFiles) {
            App.processPDFFile(file);
            float percent = (counter += 1.0f) / total * 100.0f;
            MAINWINDOW.setProgress((int)percent);
        }
        MAINWINDOW.start();
        JOptionPane.showMessageDialog(MAINWINDOW, "Conversion finished!", "Finished!", 1);
    }

    private static void processPDFFile(File file) {
        try {
            FileInputStream input = new FileInputStream(file);
            String docText = PDFStructuredTextExtractor.importAsString((InputStream)input);
            String outFileName = file.getName().replaceAll("\\.pdf$", ".txt");
            File outFile = new File(output, outFileName);
            outFile.delete();
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            out.write(docText);
            out.close();
            input.close();
        }
        catch (IOException ex) {
            MAINWINDOW.showError("Error during parsing of " + file.getAbsolutePath() + ":\n" + ex.getMessage());
        }
    }

    private static class DisablingListSelectionModel
    extends DefaultListSelectionModel {
        private DisablingListSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(-1, -1);
        }
    }

    private static class MainWindow
    extends JFrame {
        private final JLabel outputLabel = new JLabel(new File(".").getAbsolutePath());
        private final JProgressBar progBar = new JProgressBar(0, 100);
        private final ReentrantLock progLock = new ReentrantLock();

        public MainWindow() throws HeadlessException {
            super("SCIE PDF Text Extractor Version 1.0.1");
            this.setDefaultCloseOperation(3);
        }

        public void start() {
            Container pane = this.getContentPane();
            pane.removeAll();
            pane.setPreferredSize(new Dimension(800, 400));
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 15, 2, 15);
            c.fill = 2;
            c.weightx = 0.5;
            c.weighty = 0.1;
            pane.add((Component)new JLabel("Input Files: "), c);
            c.gridx = 1;
            JButton inputButton = new JButton("Select");
            pane.add((Component)inputButton, c);
            inputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(".");
                    chooser.setMultiSelectionEnabled(true);
                    chooser.setFileSelectionMode(2);
                    int returnVal = chooser.showOpenDialog(MAINWINDOW);
                    if (returnVal == 0) {
                        File[] files = chooser.getSelectedFiles();
                        boolean valid = true;
                        for (File file : files) {
                            if (file.isDirectory() || file.getName().endsWith(".pdf")) {
                                input.addElement(file);
                                continue;
                            }
                            valid = false;
                        }
                        if (!valid) {
                            JOptionPane.showMessageDialog(MAINWINDOW, "Please select PDF files or folders containing PDF files.", "Error", 0);
                        }
                    }
                }
            });
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 0.6;
            c.gridwidth = 2;
            JList inputListView = new JList(input);
            JScrollPane scrollPane = new JScrollPane(inputListView);
            inputListView.setOpaque(false);
            inputListView.setSelectionModel(new DisablingListSelectionModel());
            pane.add((Component)scrollPane, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weightx = 0.5;
            c.weighty = 0.1;
            pane.add((Component)new JLabel("Output Folder: "), c);
            c.gridx = 1;
            JButton outputButton = new JButton("Select");
            pane.add((Component)outputButton, c);
            outputButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(".");
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showSaveDialog(MAINWINDOW);
                    if (returnVal == 0) {
                        output = chooser.getSelectedFile();
                        outputLabel.setText(output.getAbsolutePath());
                        MAINWINDOW.repaint();
                    }
                }
            });
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            pane.add((Component)this.outputLabel, c);
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 10;
            JButton startButton = new JButton("Start");
            pane.add((Component)startButton, c);
            startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.progressInit();
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                    Runnable procRunnable = new Runnable(){

                        @Override
                        public void run() {
                            App.process();
                        }
                    };
                    Thread procThread = new Thread(procRunnable);
                    procThread.start();
                }
            });
            this.pack();
            this.setVisible(true);
        }

        public void progressInit() {
            Container pane = this.getContentPane();
            pane.removeAll();
            pane.setPreferredSize(new Dimension(800, 400));
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 10;
            pane.add((Component)this.progBar, c);
            this.progBar.setString("Progress: 0 %");
            this.progBar.setStringPainted(true);
            this.setContentPane(pane);
            this.repaint();
            this.pack();
            this.setVisible(true);
        }

        public void setProgress(float percent) {
            this.progLock.lock();
            try {
                int newVal = (int)percent;
                this.progBar.setValue(newVal);
                this.progBar.setString("Progress: " + newVal + " %");
            }
            finally {
                this.progLock.unlock();
            }
        }

        public void showError(String text) {
            JOptionPane.showMessageDialog(MAINWINDOW, text, "Error", 0);
        }
    }
}

