/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XmlUtils {
    public static Boolean readBoolean(XMLStreamReader reader, String attr, Boolean defaultValue) {
        String v = reader.getAttributeValue(null, attr);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return defaultValue;
    }

    public static Integer readInt(XMLStreamReader reader, String attr, Integer defaultValue) {
        String v = reader.getAttributeValue(null, attr);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defaultValue;
    }

    public static Long readLong(XMLStreamReader reader, String attr, Long defaultValue) {
        String v = reader.getAttributeValue(null, attr);
        if (v != null) {
            return Long.parseLong(v);
        }
        return defaultValue;
    }

    public static Double readDouble(XMLStreamReader reader, String attr, Double defaultValue) {
        String v = reader.getAttributeValue(null, attr);
        if (v != null) {
            return Double.parseDouble(v);
        }
        return defaultValue;
    }

    public static Float readFloat(XMLStreamReader reader, String attr, Float defaultValue) {
        String v = reader.getAttributeValue(null, attr);
        if (v != null) {
            return Float.valueOf(Float.parseFloat(v));
        }
        return defaultValue;
    }

    public static String readString(XMLStreamReader reader, String attr, String defaultValue) {
        String value = reader.getAttributeValue(null, attr);
        return value == null ? defaultValue : value;
    }

    public static Integer readIntContent(XMLStreamReader reader, Integer defaultValue) {
        return XmlUtils.readIntContent(reader, defaultValue, 0);
    }

    public static Integer readIntContent(XMLStreamReader reader, Integer defaultValue, Integer beginIndex) {
        try {
            String v = reader.getElementText().trim();
            if (beginIndex > 0) {
                v = v.substring(beginIndex);
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException | XMLStreamException ex) {
            return defaultValue;
        }
    }
}

