/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.xml;

import de.citec.scie.ner.importer.xml.XmlState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlStateStack {
    public static final int UNSPECIFIED = Integer.MIN_VALUE;
    public static final int TOP_LEVEL = -1;
    public static final int END_ELEMENT = -2;
    public static final int OTHER_EVENT = -3;
    private static final XmlState STATE_UNSPECIFIED = new XmlState(Integer.MIN_VALUE);
    private static final XmlState STATE_TOP_LEVEL = new XmlState(-1);
    private final Map<String, Collection<XmlState>> stateMap = new HashMap<String, Collection<XmlState>>();
    private final Stack<XmlState> stack = new Stack();
    private XmlState currentState = STATE_TOP_LEVEL;
    private int lastEvent = -1;
    private int eventState = Integer.MIN_VALUE;

    public XmlStateStack(XmlState ... states) {
        for (XmlState state : states) {
            if (!this.stateMap.containsKey(state.getTagName())) {
                this.stateMap.put(state.getTagName(), new ArrayList());
            }
            this.stateMap.get(state.getTagName()).add(state);
        }
    }

    public int getState() {
        return this.currentState.getState();
    }

    public int start(String tagname) {
        XmlState newState = STATE_UNSPECIFIED;
        if (this.stateMap.containsKey(tagname)) {
            for (XmlState state : this.stateMap.get(tagname)) {
                if (!state.isParent(this.currentState)) continue;
                newState = state;
                break;
            }
        }
        this.stack.push(this.currentState);
        this.currentState = newState;
        this.eventState = newState.getState();
        return this.currentState.getState();
    }

    public int end(String tagname) {
        if (!this.stack.isEmpty() && (tagname.equals(this.currentState.getTagName()) || this.currentState == STATE_UNSPECIFIED)) {
            this.eventState = this.currentState.getState();
            this.currentState = this.stack.pop();
        }
        return this.currentState.getState();
    }

    public int handleEvent(XMLStreamReader reader) throws XMLStreamException {
        Location location = reader.getLocation();
        int event = reader.getEventType();
        if (this.lastEvent < 0 || event == this.lastEvent) {
            event = reader.next();
        }
        this.lastEvent = -1;
        switch (event) {
            case 1: {
                this.lastEvent = event;
                return this.start(reader.getLocalName());
            }
            case 2: {
                this.end(reader.getLocalName());
                return -2;
            }
        }
        return -3;
    }

    public int getEventState() {
        return this.eventState;
    }
}

