/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.xml;

import de.citec.scie.ner.importer.Importer;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.ontology.Ontology;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class XmlImporter
extends Importer {
    private static ImporterException augementException(XMLStreamReader reader, ImporterException ex) {
        Location location = reader.getLocation();
        return new ImporterException("@" + location.getLineNumber() + ":" + location.getColumnNumber() + " " + ex.getMessage(), ex.getCause());
    }

    private static XMLStreamReader getStreamReader(InputStream is) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        return factory.createXMLStreamReader(is);
    }

    protected abstract void doImportOntology(Ontology var1, XMLStreamReader var2) throws XMLStreamException, ImporterException;

    protected String doDeduceOntologyName(XMLStreamReader reader) throws XMLStreamException, ImporterException {
        return null;
    }

    @Override
    protected final void doImportOntology(Ontology ontology, InputStream is) throws IOException, ImporterException {
        try (XMLStreamReader reader = XmlImporter.getStreamReader(is);){
            this.doImportOntology(ontology, reader);
        }
        catch (XMLStreamException ex) {
            throw new ImporterException("Error while reading XML", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final String doDeduceOntologyName(InputStream is) throws IOException, ImporterException {
        try (XMLStreamReader reader = XmlImporter.getStreamReader(is);){
            String string = this.doDeduceOntologyName(reader);
            return string;
        }
        catch (XMLStreamException ex) {
            throw new ImporterException("Error while reading XML", ex);
        }
    }
}

