/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.utils;

import de.citec.scie.ner.db.types.AssociationData;
import de.citec.scie.ner.db.types.AssociationType;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.ontology.Node;
import de.citec.scie.ner.ontology.Ontology;
import java.util.ArrayList;
import java.util.Collection;

public class Associator {
    final boolean skipInvalid;
    final Collection<AssociationData> associations = new ArrayList<AssociationData>();
    Ontology ontology;

    public Associator(Ontology ontology, boolean skipInvalid) {
        this.ontology = ontology;
        this.skipInvalid = skipInvalid;
    }

    public void addAssociation(int from, int to, AssociationType type) {
        this.associations.add(new AssociationData(from, to, type));
    }

    public void storeAssociations() throws ImporterException {
        for (AssociationData association : this.associations) {
            Node nodeFrom = this.ontology.getNode(association.getFrom());
            Node nodeTo = this.ontology.getNode(association.getTo());
            if (nodeFrom == null || nodeTo == null) {
                if (this.skipInvalid) continue;
                throw new ImporterException("Association from node " + association.getFrom() + " to node " + association.getTo() + " is invalid, target node does not exist!", null);
            }
            nodeFrom.addAssociationTo(nodeTo, association.getType());
        }
    }
}

