/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.formats;

import de.citec.scie.ner.db.types.AssociationType;
import de.citec.scie.ner.db.types.OntologyParameters;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.importer.utils.Associator;
import de.citec.scie.ner.importer.xml.XmlImporter;
import de.citec.scie.ner.importer.xml.XmlState;
import de.citec.scie.ner.importer.xml.XmlStateStack;
import de.citec.scie.ner.importer.xml.XmlUtils;
import de.citec.scie.ner.modes.ComparisonMode;
import de.citec.scie.ner.ontology.Node;
import de.citec.scie.ner.ontology.Ontology;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class NativeXmlImporter
extends XmlImporter {
    private static final int ONTOLOGY = 0;
    private static final int NODE = 1;
    private static final int LABELS = 2;
    private static final int LABEL = 3;
    private static final int ASSOCIATIONS = 4;
    private static final int ASSOCIATION = 5;
    private static final XmlState[] STATES = new XmlState[]{new XmlState(0, "ontology", -1), new XmlState(1, "node", 0), new XmlState(2, "labels", 1), new XmlState(3, "label", 2), new XmlState(4, "associations", 1), new XmlState(5, "association", 4)};

    @Override
    protected final String doDeduceOntologyName(XMLStreamReader reader) throws XMLStreamException {
        XmlStateStack stack = new XmlStateStack(STATES);
        while (reader.hasNext()) {
            switch (stack.handleEvent(reader)) {
                case 0: {
                    return reader.getAttributeValue(null, "name");
                }
                case -2147483648: {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    protected final void doImportOntology(Ontology ontology, XMLStreamReader reader) throws XMLStreamException, ImporterException {
        Associator associator = new Associator(ontology, false);
        Node node = new Node(ontology.getDB(), -1);
        XmlStateStack stack = new XmlStateStack(STATES);
        while (reader.hasNext()) {
            switch (stack.handleEvent(reader)) {
                case 0: {
                    float sigma = XmlUtils.readFloat(reader, "sigma", Float.valueOf(3.0f)).floatValue();
                    float minTokenProbability = XmlUtils.readFloat(reader, "minTokenProbability", Float.valueOf(0.3f)).floatValue();
                    float minEntityProbability = XmlUtils.readFloat(reader, "minEntityProbability", Float.valueOf(0.7f)).floatValue();
                    boolean greedy = XmlUtils.readBoolean(reader, "greedy", false);
                    ontology.setParameters(new OntologyParameters(sigma, minTokenProbability, minEntityProbability, greedy));
                    break;
                }
                case 1: {
                    int id = XmlUtils.readInt(reader, "id", -1);
                    boolean root = XmlUtils.readBoolean(reader, "root", false);
                    node = ontology.addNode(id, root);
                    String label = XmlUtils.readString(reader, "label", null);
                    if (label == null) break;
                    node.addLabel(label, "", ComparisonMode.FUZZY, true);
                    break;
                }
                case 3: {
                    String type = XmlUtils.readString(reader, "type", "");
                    String mode = XmlUtils.readString(reader, "mode", "fuzzy");
                    boolean primary = XmlUtils.readBoolean(reader, "primary", false);
                    String label = reader.getElementText();
                    node.addLabel(label, type, ComparisonMode.valueOf((String)mode.toUpperCase()), primary);
                    break;
                }
                case 5: {
                    Integer to = XmlUtils.readInt(reader, "to", null);
                    AssociationType type = AssociationType.valueOf((String)XmlUtils.readString(reader, "type", "DEFAULT").toUpperCase());
                    if (to == null) {
                        throw new ImporterException("association attribute \"to\" may not be empty!", null);
                    }
                    if (node.getId() < 0) {
                        throw new ImporterException("associations are only possible if the current node has an id!", null);
                    }
                    associator.addAssociation(node.getId(), to, type);
                    break;
                }
                case -2147483648: {
                    throw new ImporterException("Unexpected XML tag \"" + reader.getLocalName() + "\"", null);
                }
            }
        }
        associator.storeAssociations();
    }
}

