/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.formats;

import de.citec.scie.ner.db.types.AssociationType;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.importer.utils.Associator;
import de.citec.scie.ner.importer.xml.XmlImporter;
import de.citec.scie.ner.importer.xml.XmlState;
import de.citec.scie.ner.importer.xml.XmlStateStack;
import de.citec.scie.ner.importer.xml.XmlUtils;
import de.citec.scie.ner.ontology.Node;
import de.citec.scie.ner.ontology.Ontology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MeshImporter
extends XmlImporter {
    private static final int DESCRIPTOR_RECORD_SET = 0;
    private static final int DESCRIPTOR_RECORD = 1;
    private static final int DESCRIPTOR_UI = 2;
    private static final int DESCRIPTOR_NAME = 3;
    private static final int PHARMACOLOGICAL_ACTION_LIST = 4;
    private static final int STRING_NAME = 5;
    private static final int TERM_LIST = 6;
    private static final int QUALIFIER_UI = 7;
    private static final int STRING_SYNONYM = 8;
    private static final int DESCRIPTOR_UI_PHARMA = 9;
    private static final int PHARMACOLOGICAL_ACTION = 10;
    private static final int DESCRIPTOR_REFERRED_TO = 11;
    private static final int ALLOWABLE_QUALIFIERS_LIST = 12;
    private static final int ALLOWABLE_QUALIFIER = 13;
    private static final int QUALIFIER_REFERRED_TO = 14;
    private static final int DESCRIPTOR_NAME_PHARMA = 15;
    private static final int STRING_PHARMA = 16;
    private static final int CONCEPT_LIST = 17;
    private static final int CONCEPT = 18;
    private static final int TERM = 19;
    private static final String DRUG_IDENTIFIER = "Q000008";
    private static final XmlState[] STATES = new XmlState[]{new XmlState(0, "DescriptorRecordSet", -1), new XmlState(0, "SupplementalRecordSet", -1), new XmlState(1, "DescriptorRecord", 0), new XmlState(1, "SupplementalRecord", 0), new XmlState(2, "DescriptorUI", 1), new XmlState(2, "SupplementalRecordUI", 1), new XmlState(9, "DescriptorUI", 4), new XmlState(3, "DescriptorName", 1), new XmlState(3, "SupplementalRecordName", 1), new XmlState(5, "String", 3), new XmlState(8, "String", 19), new XmlState(4, "PharmacologicalActionList", 1), new XmlState(10, "PharmacologicalAction", 4), new XmlState(11, "DescriptorReferredTo", 10), new XmlState(9, "DescriptorUI", 11), new XmlState(12, "AllowableQualifiersList", 1), new XmlState(13, "AllowableQualifier", 12), new XmlState(14, "QualifierReferredTo", 13), new XmlState(7, "QualifierUI", 14), new XmlState(15, "DescriptorName", 11), new XmlState(16, "String", 15), new XmlState(17, "ConceptList", 1), new XmlState(18, "Concept", 17), new XmlState(6, "TermList", 18), new XmlState(19, "Term", 6)};
    private static final Map<Integer, String> TYPE_NAMES = new HashMap<Integer, String>();

    @Override
    protected void doImportOntology(Ontology ontology, XMLStreamReader reader) throws XMLStreamException, ImporterException {
        Associator associator = new Associator(ontology, true);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> synonyms = new ArrayList<String>();
        ArrayList<Integer> refIds = new ArrayList<Integer>();
        HashMap<Integer, String> references = new HashMap<Integer, String>();
        int refId = -1;
        int id = Integer.MIN_VALUE;
        boolean isDrug = false;
        XmlStateStack stack = new XmlStateStack(STATES);
        while (reader.hasNext()) {
            int ev = stack.handleEvent(reader);
            switch (ev) {
                case 5: {
                    String name = reader.getElementText();
                    names.add(name);
                    break;
                }
                case 8: {
                    String name = reader.getElementText();
                    synonyms.add(name);
                    break;
                }
                case 2: {
                    id = XmlUtils.readIntContent(reader, -1, 1);
                    break;
                }
                case 9: {
                    int from = XmlUtils.readIntContent(reader, -1, 1);
                    refIds.add(from);
                    refId = from;
                    break;
                }
                case 16: {
                    String name = reader.getElementText().trim();
                    references.put(refId, name);
                    refId = -1;
                    break;
                }
                case 7: {
                    if (!reader.getElementText().trim().equals(DRUG_IDENTIFIER)) break;
                    isDrug = true;
                    break;
                }
                case 4: {
                    isDrug = true;
                    break;
                }
                case -2: {
                    if (stack.getEventState() != 1) break;
                    if (isDrug) {
                        Node node = id > Integer.MIN_VALUE ? ontology.getNodeOrCreate(id) : ontology.addNode();
                        for (Integer rId : refIds) {
                            Node refNode = ontology.getNodeOrCreate(rId.intValue());
                            refNode.addLabel((String)references.get(rId));
                            associator.addAssociation(node.getId(), refNode.getId(), AssociationType.IS_A);
                        }
                        for (String name : names) {
                            node.addLabel(name, TYPE_NAMES.get(5));
                        }
                        for (String synonym : synonyms) {
                            node.addLabel(synonym, TYPE_NAMES.get(8));
                        }
                    }
                    refIds.clear();
                    names.clear();
                    synonyms.clear();
                    references.clear();
                    id = Integer.MIN_VALUE;
                    isDrug = false;
                }
            }
        }
        associator.storeAssociations();
    }

    static {
        TYPE_NAMES.put(5, "name");
        TYPE_NAMES.put(8, "synonym");
    }
}

