/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer.formats;

import de.citec.scie.ner.importer.Importer;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.importer.formats.MeshImporter;
import de.citec.scie.ner.importer.formats.NativeXmlImporter;
import de.citec.scie.ner.importer.formats.NcbiImporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FormatRegisty {
    private static final Map<String, Importer> REGISTERED_IMPORTERS = new HashMap<String, Importer>();

    public static Importer getImporterForFormat(String format) throws ImporterException {
        if (REGISTERED_IMPORTERS.containsKey(format)) {
            return REGISTERED_IMPORTERS.get(format);
        }
        throw new ImporterException("No importer for format " + format + " found!", null);
    }

    public static Set<String> getRegisteredFormats() {
        return REGISTERED_IMPORTERS.keySet();
    }

    static {
        REGISTERED_IMPORTERS.put("native", new NativeXmlImporter());
        REGISTERED_IMPORTERS.put("ncbi", new NcbiImporter());
        REGISTERED_IMPORTERS.put("mesh", new MeshImporter());
    }
}

