/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer;

import de.citec.scie.ner.db.interfaces.AbstractDatabase;
import de.citec.scie.ner.db.mapdb.MapDBDatabase;
import de.citec.scie.ner.importer.Importer;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.importer.formats.FormatRegisty;
import de.citec.scie.ner.ontology.OntologyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImporterCLI {
    private static void printUsage() {
        System.err.println("Usage:");
        System.err.println("\tImporterCLI <DATABASE FILE> <IMPORT TASK 1> [<IMPORT TASK 2> ...]");
        System.err.println("Where <IMPORT TASK> has the following form:");
        System.err.println("\t<FILENAME> --format <ONTOLOGY FORMAT> [--force] [--name <ONTOLGOY NAME>] [--folder]");
        System.err.println("\t--format");
        System.err.println("\t\tThe format from which the file should be imported.");
        System.err.println("\t\tSupported formats:");
        for (String format : FormatRegisty.getRegisteredFormats()) {
            System.err.println("\t\t\t" + format);
        }
        System.err.println("\t--force");
        System.err.println("\t\tIf given, ignores the file modification date");
        System.err.println("\t\t(overrides existing ontologies).");
        System.err.println("\t--name <ONTOLOGY NAME>");
        System.err.println("\t\tIs the optional name of the ontology into which");
        System.err.println("\t\tthe file should be imported. If not given, the name");
        System.err.println("\t\tspecified in the file itself is used (if available).");
        System.err.println("\t\tOtherwise the name is deduced from the filename.");
        System.err.println("\t--folder");
        System.err.println("\t\tInterprets the filename as a folder and imports");
        System.err.println("\t\tall files. Incompatible with --name.");
    }

    private static void error(String err) {
        System.err.println("ERROR: " + err);
        System.err.println();
        ImporterCLI.printUsage();
        System.exit(1);
    }

    private static String parseParam(String[] args, int i) {
        String arg = args[i];
        if (i < args.length) {
            return args[++i];
        }
        ImporterCLI.error("Expected identifier after " + arg);
        return null;
    }

    private static Setup parseArgs(String[] args) {
        Setup res = new Setup();
        String format = null;
        ImportTask currentEntry = new ImportTask();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i == 0) {
                res.db = arg;
                continue;
            }
            if (arg.startsWith("--")) {
                switch (arg) {
                    case "--force": {
                        currentEntry.force = true;
                        break;
                    }
                    case "--folder": {
                        currentEntry.isFolder = true;
                        break;
                    }
                    case "--name": {
                        currentEntry.name = ImporterCLI.parseParam(args, i++);
                        break;
                    }
                    case "--format": {
                        currentEntry.format = format = ImporterCLI.parseParam(args, i++).toLowerCase();
                        break;
                    }
                    default: {
                        ImporterCLI.error("Unexpected argument " + arg);
                        break;
                    }
                }
                continue;
            }
            if (currentEntry.filename != null) {
                res.tasks.add(currentEntry);
                if (currentEntry.format == null) {
                    currentEntry.format = format;
                }
                currentEntry = new ImportTask();
            }
            currentEntry.filename = arg;
        }
        if (currentEntry.filename != null) {
            if (currentEntry.format == null) {
                currentEntry.format = format;
            }
            res.tasks.add(currentEntry);
        }
        return res;
    }

    private static void sanitizeSetup(Setup setup) throws IOException {
        for (int i = 0; i < setup.tasks.size(); ++i) {
            File f;
            ImportTask e = setup.tasks.get(i);
            if (e.format == null) {
                ImporterCLI.error("Format of import task " + e.filename + " not specified!");
            }
            if (e.isFolder && e.name != null) {
                ImporterCLI.error("--name and --folder cannot be specified for the same import task!");
            }
            if (!FormatRegisty.getRegisteredFormats().contains(e.format)) {
                ImporterCLI.error("Specified format " + e.format + " does not exist!");
            }
            if (!(f = new File(e.filename)).exists()) {
                ImporterCLI.error("Given file " + e.filename + " does not exist!");
            }
            if (!f.isFile() && !e.isFolder) {
                ImporterCLI.error("Given file " + e.filename + " is not a regular file!");
            }
            if (!f.isDirectory() && e.isFolder) {
                ImporterCLI.error("Given file " + e.filename + " is not a directory as specified!");
            }
            e.filename = f.getCanonicalPath();
            if (!e.isFolder) continue;
            setup.tasks.remove(i);
            --i;
            for (File f2 : f.listFiles()) {
                if (!f2.isFile()) continue;
                ImportTask entry = new ImportTask();
                entry.filename = f2.getCanonicalPath();
                entry.force = e.force;
                entry.format = e.format;
                setup.tasks.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ImporterException {
        int res = 0;
        Setup setup = ImporterCLI.parseArgs(args);
        if (setup.db == null) {
            ImporterCLI.error("No database specified!");
        }
        ImporterCLI.sanitizeSetup(setup);
        if (setup.tasks.isEmpty()) {
            ImporterCLI.error("No import task specified!");
        }
        for (ImportTask e : setup.tasks) {
            System.err.println("Scheduled for import: " + e.filename + " (format " + e.format + ")");
        }
        MapDBDatabase db = new MapDBDatabase(setup.db);
        try {
            for (ImportTask e : setup.tasks) {
                System.err.println("Importing: " + e.filename + " (format " + e.format + ")");
                Importer importer = FormatRegisty.getImporterForFormat(e.format);
                try {
                    if (importer.importOntology((AbstractDatabase)db, e.filename, e.name, e.force)) continue;
                    System.err.println("Skipping, File " + e.filename + " older than" + " ontology in database. Use --force to override.");
                }
                catch (ImporterException | OntologyException ex) {
                    res = 1;
                    System.err.println("Error while importing " + e.filename);
                    ex.printStackTrace(System.err);
                }
            }
        }
        finally {
            db.commit();
            db.close();
        }
        System.exit(res);
    }

    private static class Setup {
        public List<ImportTask> tasks = new ArrayList<ImportTask>();
        public String db = null;

        private Setup() {
        }
    }

    private static class ImportTask {
        public String filename = null;
        public String format = null;
        public boolean force = false;
        public boolean isFolder = false;
        public String name = null;

        private ImportTask() {
        }
    }
}

