/*
 * Decompiled with CFR 0.152.
 */
package de.citec.scie.ner.importer;

import de.citec.scie.ner.db.interfaces.AbstractDatabase;
import de.citec.scie.ner.importer.ImporterException;
import de.citec.scie.ner.ontology.Ontology;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public abstract class Importer {
    private static final String CHARSET = "UTF-8";

    private static InputStream getStringStream(String data) throws ImporterException {
        try {
            return new ByteArrayInputStream(data.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException ex) {
            throw new ImporterException("Error while converting string to stram", ex);
        }
    }

    protected abstract void doImportOntology(Ontology var1, InputStream var2) throws IOException, ImporterException;

    protected String doDeduceOntologyName(InputStream is) throws IOException, ImporterException {
        return null;
    }

    protected int getDeductionReadLimit() {
        return 16384;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deduceOntologyName(InputStream is) throws IOException, ImporterException {
        try {
            is.mark(this.getDeductionReadLimit());
            try {
                String string = this.doDeduceOntologyName(is);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                is.reset();
                return string;
            }
        }
        finally {
            is.reset();
        }
    }

    public String deduceOntologyName(String data) throws IOException, ImporterException {
        return this.deduceOntologyName(Importer.getStringStream(data));
    }

    public String deduceOntologyName(InputStream is, String filename) throws IOException, ImporterException {
        String name = this.deduceOntologyName(is);
        if (name == null && filename != null) {
            name = Importer.deduceOntologyNameFromFilename(filename);
        }
        return name;
    }

    protected static String deduceOntologyNameFromFilename(String s) {
        int lastSlash = Math.max(s.lastIndexOf(47), s.lastIndexOf(92)) + 1;
        int lastDot = s.lastIndexOf(46) < lastSlash ? s.length() : s.lastIndexOf(46);
        return s.substring(lastSlash, lastDot).replaceAll("[ -.]", "_");
    }

    public final void importOntology(Ontology ontology, InputStream is) throws ImporterException {
        try {
            this.doImportOntology(ontology, is);
        }
        catch (IOException ex) {
            throw new ImporterException("I/O error while importing ontology", ex);
        }
    }

    public final boolean importOntology(AbstractDatabase db, InputStream is, String name, String filename, Date date, boolean force) throws ImporterException {
        try {
            Ontology onto;
            if (name == null) {
                name = this.deduceOntologyName(is, filename);
            }
            if (name == null || name.isEmpty()) {
                throw new ImporterException("Empty ontology name", null);
            }
            if (!force && date != null && (onto = Ontology.getOntologyByName((AbstractDatabase)db, (String)name)) != null && onto.getModificationDate().after(date)) {
                return false;
            }
            onto = Ontology.getEmptyOntology((AbstractDatabase)db, (String)name);
            this.importOntology(onto, is);
            onto.setModificationDate(new Date());
            return true;
        }
        catch (IOException ex) {
            throw new ImporterException("I/O error while importing ontology", ex);
        }
    }

    public final void importOntology(AbstractDatabase db, InputStream is, String name, String filename) throws ImporterException {
        this.importOntology(db, is, name, filename, null, true);
    }

    /*
     * Exception decompiling
     */
    public final boolean importOntology(AbstractDatabase db, String filename, String name, boolean force) throws ImporterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void importOntology(AbstractDatabase db, String data, String name, String filename) throws ImporterException {
        this.importOntology(db, Importer.getStringStream(data), name, filename);
    }

    public final void importOntology(AbstractDatabase db, String data, String name) throws ImporterException {
        this.importOntology(db, Importer.getStringStream(data), name, null);
    }

    private static class ProgressInputStream
    extends FilterInputStream {
        private static final int UPDATE_INTERVAL = 131072;
        private final long size;
        private int read;
        private int accu;
        private boolean closed;

        public ProgressInputStream(InputStream is, long size) {
            super(is);
            this.size = size;
            this.read = 0;
            this.accu = 0;
            this.closed = false;
        }

        private void showProgress() {
            double p = (double)Math.min(this.size, (long)this.read) / (double)this.size;
            System.err.printf("%4.1f%%\r", p * 100.0);
        }

        private int increment(int step) {
            if (step > 0) {
                this.accu += step;
                while (this.accu >= 131072) {
                    this.accu -= 131072;
                    this.read += 131072;
                    this.showProgress();
                }
            }
            return step;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                System.err.print("100.0%\n");
                this.closed = true;
            }
            super.close();
        }

        @Override
        public int read() throws IOException {
            int res = this.in.read();
            if (res >= 0) {
                this.increment(1);
            }
            return res;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.increment(this.in.read(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.increment(this.in.read(b, off, len));
        }
    }
}

