/*
 * Decompiled with CFR 0.152.
 */
package de.citec.ml.rng;

import de.citec.ml.rng.CheckFunctions;
import de.citec.ml.rng.RNGModel;

public final class RelationalDistances {
    private RelationalDistances() {
    }

    public static double[][] getDistancesToPrototypes(double[][] D, RNGModel model) {
        return RelationalDistances.getDistancesToPrototypes(D, model.getConvexCoefficients(), model.getNormalizationTerms());
    }

    public static double[] getDistancesToPrototypes(double[] d, RNGModel model) {
        return RelationalDistances.getDistancesToPrototypes(d, model.getConvexCoefficients(), model.getNormalizationTerms());
    }

    protected static double[][] getDistancesToPrototypes(double[][] D, double[][] Alpha, double[] Z) {
        IllegalArgumentException ex = CheckFunctions.checkDissimilaritiesOfDatapointsToPrototypes(D);
        if (ex != null) {
            throw ex;
        }
        int n = D.length;
        double[][] Dp = new double[n][];
        for (int j = 0; j < n; ++j) {
            Dp[j] = RelationalDistances.getDistancesToPrototypes(D[j], Alpha, Z);
        }
        return Dp;
    }

    protected static double[] getDistancesToPrototypes(double[] d, double[][] Alpha, double[] Z) {
        int m = d.length;
        int K = Alpha.length;
        double[] dp = new double[K];
        for (int k = 0; k < K; ++k) {
            for (int i = 0; i < m; ++i) {
                int n = k;
                dp[n] = dp[n] + Alpha[k][i] * d[i] * d[i];
            }
            int n = k;
            dp[n] = dp[n] + Z[k];
        }
        return dp;
    }

    protected static double[] getNormalizationTerms(double[][] D, double[][] Alpha) {
        int K = Alpha.length;
        int m = D.length;
        double[] Z = new double[K];
        int k = 0;
        while (k < K) {
            for (int i = 0; i < m; ++i) {
                if (Alpha[k][i] == 0.0) continue;
                for (int j = 0; j < m; ++j) {
                    int n = k;
                    Z[n] = Z[n] + Alpha[k][i] * D[i][j] * D[i][j] * Alpha[k][j];
                }
            }
            int n = k++;
            Z[n] = Z[n] * -0.5;
        }
        return Z;
    }
}

