/*
 * Decompiled with CFR 0.152.
 */
package de.citec.ml.rng;

import de.citec.ml.rng.CheckFunctions;
import de.citec.ml.rng.RNGErrorModel;

public class RNGModelImpl
implements RNGErrorModel {
    private final double[][] Alpha;
    private final double[][] Dp;
    private final double[] Z;
    private final double[] errors;

    public RNGModelImpl(double[][] Alpha, double[][] Dp, double[] Z) {
        this(Alpha, Dp, Z, null);
    }

    public RNGModelImpl(double[][] Alpha, double[][] Dp, double[] Z, double[] errors) {
        IllegalArgumentException ex = CheckFunctions.checkDissimilaritiesOfDatapointsToPrototypes(Dp);
        if (ex != null) {
            throw ex;
        }
        this.Dp = Dp;
        int m = Dp.length;
        int K = Dp[0].length;
        ex = CheckFunctions.checkConvexCoefficients(m, K, Alpha);
        if (ex != null) {
            throw ex;
        }
        this.Alpha = Alpha;
        if (Z == null || Z.length != K) {
            throw new IllegalArgumentException("Expected a " + K + " x 1 vector of normalization terms as third constructor argument!");
        }
        this.Z = Z;
        this.errors = errors;
    }

    @Override
    public int getNumberOfDatapoints() {
        return this.Dp.length;
    }

    @Override
    public int getNumberOfPrototypes() {
        return this.Alpha.length;
    }

    @Override
    public double[][] getDistancesToPrototypes() {
        return this.Dp;
    }

    @Override
    public double[] getNormalizationTerms() {
        return this.Z;
    }

    @Override
    public double[][] getConvexCoefficients() {
        return this.Alpha;
    }

    @Override
    public int getNumberOfEpochs() {
        return this.errors.length;
    }

    @Override
    public double[] getQuantizationErrors() {
        return this.errors;
    }
}

