/*
 * Decompiled with CFR 0.152.
 */
package de.citec.ml.rng;

public final class CheckFunctions {
    private static final double DOUBLE_TOLERANCE = 1.0E-8;

    private CheckFunctions() {
    }

    public static IllegalArgumentException checkDissimilarityMatrix(double[][] D) {
        int i;
        if (D == null) {
            return new IllegalArgumentException(new NullPointerException("Input matrix is null."));
        }
        int m = D.length;
        if (m == 0) {
            return new IllegalArgumentException("The input matrix is empty.");
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (D[i2].length == m) continue;
            return new IllegalArgumentException("In row " + i2 + " the input matrix has " + D[i2].length + " columns, but we expected " + m + " columns.");
        }
        double sum = 0.0;
        for (int i3 = 0; i3 < m; ++i3) {
            for (int j = 0; j < m; ++j) {
                sum += D[i3][j];
            }
        }
        double mean = sum / (double)(m * m);
        double tolerance = mean * 1.0E-8;
        for (i = 0; i < m; ++i) {
            if (!(D[i][i] > tolerance)) continue;
            return new IllegalArgumentException("The given matrix is not reflective: Entry (" + i + ", " + i + ") is larger than zero.");
        }
        for (i = 0; i < m; ++i) {
            for (int j = i + 1; j < m; ++j) {
                if (!(Math.abs(D[i][j] - D[j][i]) > tolerance)) continue;
                return new IllegalArgumentException("The given matrix is not symmetric: Entry (" + i + ", " + j + ") and entry (" + j + ", " + i + ") do not equal.");
            }
        }
        return null;
    }

    public static IllegalArgumentException checkConvexCoefficients(int m, int K, double[][] Alpha) {
        if (Alpha == null) {
            return new IllegalArgumentException(new NullPointerException("Input matrix is null."));
        }
        if (Alpha.length != K) {
            return new IllegalArgumentException("Expected a convex combination for each of the " + K + " prototypes, but the given matrix has " + Alpha.length + " rows.");
        }
        for (int k = 0; k < K; ++k) {
            IllegalArgumentException ex = CheckFunctions.checkConvexCoefficients(m, Alpha[k]);
            if (ex == null) continue;
            return new IllegalArgumentException("The given vector for prototype " + k + " is not a proper convex combination.", ex);
        }
        return null;
    }

    public static IllegalArgumentException checkConvexCoefficients(int m, double[] alpha) {
        if (alpha == null) {
            return new IllegalArgumentException(new NullPointerException("Input vector is null."));
        }
        if (alpha.length != m) {
            return new IllegalArgumentException("Expected a convex combination for " + m + " data points, but the given vector had " + alpha.length + " entries.");
        }
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            if (alpha[i] < 0.0) {
                return new IllegalArgumentException("Entry " + i + " of the given vector is negative.");
            }
            sum += alpha[i];
        }
        if (Math.abs(sum - 1.0) > 1.0E-8) {
            return new IllegalArgumentException("The given vector does not sum up to 1 but to " + sum);
        }
        return null;
    }

    public static IllegalArgumentException checkAssignmentsVector(int N, int K, int[] assignments) {
        if (assignments == null) {
            return new IllegalArgumentException(new NullPointerException("Input vector is null."));
        }
        if (assignments.length != N) {
            return new IllegalArgumentException("Expected an assignments vector for " + N + " data points, but the given vector had " + assignments.length + " entries.");
        }
        for (int i = 0; i < N; ++i) {
            if (assignments[i] >= 0 && assignments[i] < K) continue;
            return new IllegalArgumentException("Expected " + K + " clusters, but data point " + i + " is assigned to cluster" + assignments[i]);
        }
        return null;
    }

    public static IllegalArgumentException checkDissimilaritiesOfDatapointsToPrototypes(double[][] Dp) {
        if (Dp == null) {
            return new IllegalArgumentException(new NullPointerException("Input matrix is null."));
        }
        int K = Dp.length;
        if (K == 0) {
            return new IllegalArgumentException("The input matrix is empty.");
        }
        int m = Dp[0].length;
        for (int i = 1; i < K; ++i) {
            if (Dp[i].length == m) continue;
            return new IllegalArgumentException("In row " + i + " the input matrix has " + Dp[i].length + " columns, but we expected " + m + " columns.");
        }
        return null;
    }
}

