/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.server.comparators.DefaultStateComparator;
import de.cinovo.cloudconductor.server.comparators.PackageVersionComparator;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageServerDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDefaultStateDAO;
import de.cinovo.cloudconductor.server.dao.IServiceStateDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageServer;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceDefaultState;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.interfaces.ITemplate;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class TemplatesImpl
extends AWebPage
implements ITemplate {
    @Autowired
    protected ITemplateDAO dTemplate;
    @Autowired
    private IPackageDAO dPkg;
    @Autowired
    private IServiceDefaultStateDAO dSvcDefState;
    @Autowired
    private IServiceStateDAO dSvcState;
    @Autowired
    private IPackageServerDAO dPackageServer;
    @Autowired
    private IServiceDAO dSvc;
    @Autowired
    private IPackageVersionDAO dPkgVersion;

    @Override
    protected String getTemplateFolder() {
        return "templates";
    }

    @Override
    protected void init() {
        this.navRegistry.registerMainMenu(this.getNavElementName(), "/templates");
        this.addBreadCrumb("/web/templates", this.getNavElementName());
        this.addTopAction("/web/templates/add", "Create new Template");
    }

    @Override
    protected String getNavElementName() {
        return "Templates";
    }

    @Override
    @Transactional
    public RenderedView view() {
        List etemplates = this.dTemplate.findList();
        ArrayList<String> updates = new ArrayList<String>();
        for (ETemplate t : etemplates) {
            this.addSidebarElement(t.getName());
            this.sortNamedList(t.getHosts());
            Collections.sort(t.getPackageVersions(), new PackageVersionComparator());
            for (EPackageVersion pv : t.getPackageVersions()) {
                ArrayList<EPackageVersion> versionsOfPackage = new ArrayList<EPackageVersion>(pv.getPkg().getRPMs());
                Collections.sort(versionsOfPackage, new PackageVersionComparator());
                if (((EPackageVersion)versionsOfPackage.get(versionsOfPackage.size() - 1)).equals(pv)) continue;
                updates.add(pv.getName());
            }
        }
        this.sortNamedList(etemplates);
        CSViewModel view = this.createView();
        view.addModel("TEMPLATES", etemplates);
        view.addModel("UPDATE", updates);
        return view.render();
    }

    @Override
    @Transactional
    public AjaxAnswer updatePackages(String tname, List<String> updatePackages) {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        if (updatePackages == null || updatePackages.isEmpty() || template == null) {
            return new AjaxAnswer("/web/templates");
        }
        HashSet<EPackageVersion> remove = new HashSet<EPackageVersion>();
        for (EPackageVersion installed : template.getPackageVersions()) {
            if (!updatePackages.contains(installed.getPkg().getName())) continue;
            remove.add(installed);
        }
        template.getPackageVersions().removeAll(remove);
        for (String pkg : updatePackages) {
            EPackage ep = (EPackage)this.dPkg.findByName(pkg);
            ArrayList<EPackageVersion> rpms = new ArrayList<EPackageVersion>(ep.getRPMs());
            Collections.sort(rpms, new PackageVersionComparator());
            if (template.getPackageVersions().contains(rpms.get(rpms.size() - 1))) continue;
            template.getPackageVersions().add((EPackageVersion)rpms.get(rpms.size() - 1));
        }
        this.dTemplate.save(template);
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public AjaxAnswer changeTemplateState(String tname, List<String> deletePackages) {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        if (deletePackages == null || deletePackages.isEmpty() || template == null) {
            return new AjaxAnswer("/web/templates");
        }
        HashSet<EPackageVersion> remove = new HashSet<EPackageVersion>();
        for (EPackageVersion installed : template.getPackageVersions()) {
            if (!deletePackages.contains(installed.getPkg().getName())) continue;
            remove.add(installed);
        }
        template.getPackageVersions().removeAll(remove);
        List<EServiceDefaultState> defaultStates = this.dSvcDefState.findByTemplate(tname);
        block1: for (EServiceDefaultState state : defaultStates) {
            for (EPackage pkg : state.getService().getPackages()) {
                if (!deletePackages.contains(pkg.getName())) continue;
                this.dSvcDefState.delete(state);
                continue block1;
            }
        }
        for (EHost host : template.getHosts()) {
            block4: for (EServiceState service : host.getServices()) {
                for (EPackage pkg : service.getService().getPackages()) {
                    if (!deletePackages.contains(pkg.getName())) continue;
                    this.dSvcState.delete(service);
                    continue block4;
                }
            }
        }
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public RenderedView editTemplateView(String tname) {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        CSViewModel vm = this.createModal("mEditTemplate");
        vm.addModel("template", template);
        vm.addModel("availablePM", this.dPackageServer.findList());
        return vm.render();
    }

    @Override
    @Transactional
    public AjaxAnswer editTemplate(String tname, String templatename, Long packageManagerId, String description, String autoupdate, String smoothupdate) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)tname);
        this.templateOptionErrorHandling(templatename, packageManagerId, description, autoupdate, smoothupdate);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        template.setName(templatename);
        template.setDescription(description);
        template.setYum((EPackageServer)this.dPackageServer.findById(packageManagerId));
        template.setAutoUpdate(Boolean.valueOf(autoupdate));
        template.setSmoothUpdate(Boolean.valueOf(smoothupdate));
        this.dTemplate.save(template);
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public RenderedView addPackageView(String tname) {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        List pkgList = this.dPkg.findList();
        for (EPackageVersion pv : template.getPackageVersions()) {
            pkgList.remove(pv.getPkg());
        }
        this.sortNamedList(pkgList);
        CSViewModel vm = this.createModal("mAddPackage");
        vm.addModel("template", template);
        vm.addModel("packages", pkgList);
        return vm.render();
    }

    @Override
    @Transactional
    public AjaxAnswer addPackage(String tname, String[] pkgs) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)tname);
        if (pkgs == null || pkgs.length < 1) {
            throw this.createError("Please choose one or more packages!");
        }
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        for (String pkg : pkgs) {
            EService s;
            EServiceDefaultState sds;
            EPackage ep = (EPackage)this.dPkg.findByName(pkg);
            ArrayList<EPackageVersion> pvs = new ArrayList<EPackageVersion>(ep.getRPMs());
            Collections.sort(pvs, new PackageVersionComparator());
            template.getPackageVersions().add((EPackageVersion)pvs.get(pvs.size() - 1));
            Iterator<EService> i$ = this.dSvc.findByPackage(ep).iterator();
            if (!i$.hasNext() || (sds = this.dSvcDefState.findByName((s = i$.next()).getName(), template.getName())) != null) continue;
            sds = new EServiceDefaultState();
            sds.setService(s);
            sds.setTemplate(template);
            sds.setState(ServiceState.STOPPED);
            this.dSvcDefState.save(sds);
        }
        this.dTemplate.save(template, "Added packages " + this.auditFormat(pkgs) + " to template " + tname);
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public RenderedView deleteTemplateView(String tname) {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        CSViewModel modal = this.createModal("mDeleteTemplate");
        modal.addModel("template", template);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer deleteTemplate(String tname) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)tname);
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        if (template == null || template.getHosts().size() > 0) {
            throw this.createError("The template <b>" + tname + "</b> can't be removed. There are still hosts alive using this Template");
        }
        this.dTemplate.delete(template);
        this.removeSidebarElement(tname);
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public RenderedView defaultServiceStatesView(String tname) {
        ETemplate template = (ETemplate)this.dTemplate.findByName(tname);
        for (EService svc : this.dSvc.findList()) {
            for (EPackageVersion pkv : template.getPackageVersions()) {
                if (!svc.getPackages().contains(pkv.getPkg())) continue;
                this.setDefaultService(svc, template);
            }
        }
        List<EServiceDefaultState> defaultStates = this.dSvcDefState.findByTemplate(template.getName());
        Collections.sort(defaultStates, new DefaultStateComparator());
        CSViewModel modal = this.createModal("mDefaultServices");
        modal.addModel("template", template);
        modal.addModel("defaultStates", defaultStates);
        return modal.render();
    }

    private void setDefaultService(EService service, ETemplate template) {
        EServiceDefaultState sds = this.dSvcDefState.findByName(service.getName(), template.getName());
        if (sds == null) {
            sds = new EServiceDefaultState();
            sds.setService(service);
            sds.setTemplate(template);
            sds.setState(ServiceState.STOPPED);
            this.dSvcDefState.save(sds);
        }
    }

    @Override
    @Transactional
    public AjaxAnswer changeDefaultServiceStates(String tname, List<String> startService, List<String> stopService) {
        RESTAssert.assertNotEmpty((String)tname);
        if (startService.isEmpty() && stopService.isEmpty()) {
            return new AjaxAnswer("/web/templates");
        }
        List<EServiceDefaultState> services = this.dSvcDefState.findByTemplate(tname);
        for (EServiceDefaultState eservice : services) {
            if (!startService.contains(eservice.getService().getName())) continue;
            eservice.setState(ServiceState.RUNNING);
            this.dSvcDefState.save(eservice);
        }
        for (EServiceDefaultState eservice : services) {
            if (!stopService.contains(eservice.getService().getName())) continue;
            eservice.setState(ServiceState.STOPPED);
            this.dSvcDefState.save(eservice);
        }
        return new AjaxAnswer("/web/templates");
    }

    @Override
    @Transactional
    public RenderedView addTemplateView() {
        CSViewModel modal = this.createModal("mAddTemplate");
        modal.addModel("availablePM", this.dPackageServer.findList());
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer addTemplate(String templatename, Long packageManagerId, String description, String autoupdate, String smoothupdate) throws FormErrorException {
        this.templateOptionErrorHandling(templatename, packageManagerId, description, autoupdate, smoothupdate);
        ETemplate template = new ETemplate();
        RESTAssert.assertNotNull((Object)template);
        template.setName(templatename);
        template.setDescription(description);
        template.setYum((EPackageServer)this.dPackageServer.findById(packageManagerId));
        template.setAutoUpdate(Boolean.valueOf(autoupdate));
        template.setSmoothUpdate(Boolean.valueOf(smoothupdate));
        this.dTemplate.save(template);
        return new AjaxAnswer("/web/templates");
    }

    private void templateOptionErrorHandling(String templatename, Long packageManagerId, String description, String autoupdate, String smoothupdate) throws FormErrorException {
        String errorMessage = "Please fill in all the information.";
        FormErrorException error = null;
        error = this.checkForEmpty(templatename, errorMessage, error, "templatename");
        error = this.checkForEmpty(packageManagerId.toString(), errorMessage, error, "packageManager");
        if (packageManagerId < 0L) {
            if (error == null) {
                error = this.createError(errorMessage);
            }
            error.addElementError("packageManager", true);
        }
        if (error != null) {
            error.addFormParam("templatename", templatename);
            error.addFormParam("packageManager", packageManagerId.toString());
            error.addFormParam("description", description);
            error.addFormParam("autoupdate", autoupdate);
            error.addFormParam("smoothupdate", smoothupdate);
            throw error;
        }
    }
}

