/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.helper.SidebarType;
import de.cinovo.cloudconductor.server.web.interfaces.IServices;
import de.taimos.restutils.RESTAssert;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl
extends AWebPage
implements IServices {
    @Autowired
    private IServiceDAO dService;
    @Autowired
    private IPackageDAO dPackage;

    @Override
    protected String getTemplateFolder() {
        return "services";
    }

    @Override
    protected void init() {
        this.navRegistry.registerSubMenu(NavbarHardLinks.config, this.getNavElementName(), "/services");
        this.addBreadCrumb("/web/services", this.getNavElementName());
        this.addTopAction("/web/services/add", "Create new Service");
    }

    @Override
    protected SidebarType getSidebarType() {
        return SidebarType.ALPHABETICAL;
    }

    @Override
    protected String getNavElementName() {
        return "Services";
    }

    @Override
    @Transactional
    public RenderedView view() {
        List services = this.dService.findList();
        for (EService svc : services) {
            this.addSidebarElement(svc.getName());
            svc.getPackages().size();
        }
        this.sortNamedList(services);
        CSViewModel view = this.createView();
        view.addModel("SERVICES", services);
        return view.render();
    }

    @Override
    public RenderedView newServiceView() {
        CSViewModel modal = this.createModal("mModService");
        List packages = this.dPackage.findList();
        this.sortNamedList(packages);
        modal.addModel("PACKAGES", packages);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView editServiceView(String service) {
        RESTAssert.assertNotEmpty((String)service);
        CSViewModel modal = this.createModal("mModService");
        EService svc = (EService)this.dService.findByName(service);
        RESTAssert.assertNotNull((Object)svc);
        svc.getPackages().size();
        List packages = this.dPackage.findList();
        this.sortNamedList(packages);
        modal.addModel("SERVICE", svc);
        modal.addModel("PACKAGES", packages);
        return modal.render();
    }

    @Override
    public RenderedView deleteServiceView(String service) {
        RESTAssert.assertNotEmpty((String)service);
        CSViewModel modal = this.createModal("mDeleteService");
        modal.addModel("SERVICE", this.dService.findByName(service));
        return modal.render();
    }

    @Override
    public RenderedView deletePackageView(String service, String pkg) {
        RESTAssert.assertNotEmpty((String)service);
        RESTAssert.assertNotEmpty((String)pkg);
        CSViewModel modal = this.createModal("mDeletePackage");
        modal.addModel("SERVICE", this.dService.findByName(service));
        modal.addModel("PACKAGE", this.dPackage.findByName(pkg));
        return modal.render();
    }

    @Override
    public RenderedView addPackageView(String service) {
        RESTAssert.assertNotEmpty((String)service);
        EService svc = (EService)this.dService.findByName(service);
        List<EPackage> pkgs = this.dPackage.findNotUsedPackage(svc);
        this.sortNamedList(pkgs);
        CSViewModel modal = this.createModal("mAddPackage");
        modal.addModel("SERVICE", svc);
        modal.addModel("PACKAGES", pkgs);
        return modal.render();
    }

    @Override
    public AjaxAnswer deleteService(String service) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)service);
        EService svc = (EService)this.dService.findByName(service);
        this.dService.delete(svc);
        return new AjaxAnswer("/web/services");
    }

    @Override
    public AjaxAnswer deletePackage(String service, String pkg) throws FormErrorException {
        EPackage pkgVersion = (EPackage)this.dPackage.findByName(pkg);
        EService svc = (EService)this.dService.findByName(service);
        svc.getPackages().remove(pkgVersion);
        this.dService.save(svc, "Removed package " + pkg + " from service " + svc.getName());
        return new AjaxAnswer("/web/services");
    }

    @Override
    public AjaxAnswer addPackage(String service, String[] pkgs) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)service);
        if (pkgs == null || pkgs.length < 1) {
            throw this.createError("Please select at least one package.");
        }
        EService svc = (EService)this.dService.findByName(service);
        for (String pkg : pkgs) {
            EPackage ep = (EPackage)this.dPackage.findByName(pkg);
            if (ep == null) continue;
            svc.getPackages().add(ep);
            this.dService.save(svc);
        }
        return new AjaxAnswer("/web/services");
    }

    @Override
    public AjaxAnswer saveService(String service, String newservice, String initscript, String description, String[] pkgs) throws FormErrorException {
        RESTAssert.assertNotNull((Object)service);
        RESTAssert.assertNotEmpty((String)newservice);
        RESTAssert.assertNotEmpty((String)initscript);
        RESTAssert.assertNotEmpty((String)description);
        FormErrorException error = null;
        error = this.assertNotEmpty(newservice, error, "name");
        error = this.assertNotEmpty(initscript, error, "script");
        error = this.assertNotEmpty(initscript, error, description);
        if (!service.equals(newservice) && this.dService.findByName(newservice) != null) {
            error = error == null ? this.createError("The service name already exists.") : error;
            error.addElementError("name", true);
        }
        if (newservice != null && !newservice.isEmpty() && newservice.contains(" ")) {
            error = error == null ? this.createError("The service name may not contain spaces.") : error;
            error.addElementError("name", true);
        }
        if (error != null) {
            error.addFormParam("name", newservice);
            error.addFormParam("script", initscript);
            error.addFormParam("description", description);
            error.addFormParam("pkgs", Arrays.asList(pkgs));
            error.setParentUrl("/services", service, "/edit");
            if (service.equals("0")) {
                error.setParentUrl("/services", "/add");
            }
            throw error;
        }
        EService svc = (EService)this.dService.findByName(service);
        if (svc == null) {
            svc = new EService();
        }
        svc.setName(newservice);
        svc.setInitScript(initscript);
        svc.setDescription(description);
        svc.getPackages().clear();
        if (pkgs != null) {
            for (String pname : pkgs) {
                EPackage pkg = (EPackage)this.dPackage.findByName(pname);
                svc.getPackages().add(pkg);
            }
        }
        svc = (EService)this.dService.save(svc);
        return new AjaxAnswer("/web/services");
    }
}

