/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.server.dao.IAdditionalLinksDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EAdditionalLinks;
import de.cinovo.cloudconductor.server.model.EServerOptions;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.helper.NavbarRegistry;
import de.cinovo.cloudconductor.server.web.interfaces.IServerOptions;
import de.taimos.restutils.RESTAssert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServerOptionsImpl
extends AWebPage
implements IServerOptions {
    @Autowired
    protected IAdditionalLinksDAO dLinks;
    @Autowired
    protected ITemplateDAO dTemplate;
    @Autowired
    protected NavbarRegistry navReg;

    @Override
    protected String getTemplateFolder() {
        return "options";
    }

    @Override
    protected void init() {
    }

    @Override
    protected String getNavElementName() {
        return "Options";
    }

    @Override
    @Transactional
    public RenderedView view() {
        CSViewModel modal = this.createModal("mOptions");
        modal.addModel("options", this.dServerOptions.get());
        return modal.render();
    }

    @Override
    public RenderedView viewLinks() {
        CSViewModel modal = this.createModal("mLinks");
        modal.addModel("links", this.dLinks.findList());
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer saveOptions(String name, String bgcolor, String autoUpdate, String descr, String needsapproval) throws FormErrorException {
        FormErrorException error = null;
        error = this.assertNotEmpty(name, error, "name");
        if ((error = this.assertNotEmpty(bgcolor, error, "bgcolor")) != null) {
            error.addFormParam("name", name);
            error.addFormParam("bgcolor", bgcolor);
            error.addFormParam("allowautoupdate", autoUpdate);
            error.addFormParam("needsapproval", needsapproval);
            error.addFormParam("description", descr);
            error.setParentUrl("/options");
            throw error;
        }
        EServerOptions options = this.dServerOptions.get();
        options.setName(name);
        options.setBgcolor(bgcolor);
        options.setAllowautoupdate(autoUpdate != null);
        options.setNeedsApproval(needsapproval != null);
        options.setDescription(descr);
        this.dServerOptions.save(options);
        if (!options.isAllowautoupdate()) {
            for (ETemplate t : this.dTemplate.findList()) {
                if (!t.getAutoUpdate().booleanValue()) continue;
                t.setAutoUpdate(false);
                this.dTemplate.save(t);
            }
        }
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/options", AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully saved");
        return ajaxRedirect;
    }

    @Override
    public RenderedView addLinkView() {
        CSViewModel modal = this.createModal("mAddLink");
        return modal.render();
    }

    @Override
    public AjaxAnswer addLink(String label, String link) throws FormErrorException {
        FormErrorException error = null;
        error = this.assertNotEmpty(label, error, "label");
        if ((error = this.assertNotEmpty(link, error, "link")) != null) {
            error.addFormParam("label", label);
            error.addFormParam("link", link);
            error.setParentUrl("/options", "/links/add");
            throw error;
        }
        EAdditionalLinks add = new EAdditionalLinks();
        add.setLabel(label);
        add.setUrl(link);
        add = (EAdditionalLinks)this.dLinks.save(add);
        this.navReg.registerSubMenu(NavbarHardLinks.links, add.getLabel(), add.getUrl());
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/options/links", AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully saved");
        return ajaxRedirect;
    }

    @Override
    public RenderedView deleteLinkView(String label) {
        EAdditionalLinks link = this.dLinks.findByLabel(label);
        RESTAssert.assertNotNull((Object)link);
        CSViewModel modal = this.createModal("mDeleteLink");
        modal.addModel("link", link);
        return modal.render();
    }

    @Override
    public AjaxAnswer deleteLink(String label) {
        EAdditionalLinks link = this.dLinks.findByLabel(label);
        RESTAssert.assertNotNull((Object)link);
        this.dLinks.delete(link);
        this.navReg.unregisterSubMenu(NavbarHardLinks.links, link.getLabel());
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/options/links", AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("The link " + label + " has been deleted.");
        return ajaxRedirect;
    }
}

