/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import com.google.common.collect.Sets;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.ReportPackage;
import de.cinovo.cloudconductor.server.web.interfaces.IReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ReportImpl
extends AWebPage
implements IReport {
    @Autowired
    private ITemplateDAO dTemplate;

    @Override
    protected String getTemplateFolder() {
        return "report";
    }

    @Override
    protected void init() {
    }

    @Override
    protected String getNavElementName() {
        return "Report";
    }

    @Override
    @Transactional
    public RenderedView view() {
        List templates = this.dTemplate.findList();
        HashSet installedPackages = Sets.newHashSet();
        for (ETemplate temp : templates) {
            for (EPackageVersion rpm : temp.getPackageVersions()) {
                installedPackages.add(rpm);
            }
        }
        ArrayList<ReportPackage> packagesModel = new ArrayList<ReportPackage>();
        for (EPackageVersion pkg : installedPackages) {
            ReportPackage packageModel = new ReportPackage(pkg.getPkg().getName(), pkg.getVersion());
            packagesModel.add(packageModel);
        }
        Collections.sort(packagesModel);
        CSViewModel vm = this.createView();
        vm.addModel("packages", packagesModel);
        return vm.render();
    }
}

