/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import com.google.common.collect.ArrayListMultimap;
import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.server.comparators.PackageComparator;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDefaultStateDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceDefaultState;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.helper.SidebarType;
import de.cinovo.cloudconductor.server.web.interfaces.IPackages;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PackagesImpl
extends AWebPage
implements IPackages {
    @Autowired
    protected IPackageDAO dPkg;
    @Autowired
    protected IServiceDAO dSvc;
    @Autowired
    protected IPackageVersionDAO dVersion;
    @Autowired
    protected ITemplateDAO dTemplate;
    @Autowired
    private IServiceDefaultStateDAO dSvcDefState;

    @Override
    protected String getTemplateFolder() {
        return "packages";
    }

    @Override
    protected SidebarType getSidebarType() {
        return SidebarType.ALPHABETICAL;
    }

    @Override
    protected void init() {
        this.navRegistry.registerSubMenu(NavbarHardLinks.config, this.getNavElementName(), "/packages");
        this.addBreadCrumb("/web/packages", "Packages");
    }

    @Override
    protected String getNavElementName() {
        return "Packages";
    }

    @Override
    @Transactional
    public RenderedView view() {
        List packageList = this.dPkg.findList();
        List serviceList = this.dSvc.findList();
        ArrayListMultimap serviceMap = ArrayListMultimap.create();
        ArrayListMultimap versionMap = ArrayListMultimap.create();
        Collections.sort(packageList, new PackageComparator());
        for (EPackage pkg : packageList) {
            this.addSidebarElement(pkg.getName());
            for (EPackageVersion version : pkg.getRPMs()) {
                versionMap.put((Object)pkg.getName(), (Object)version);
            }
            for (EService s : serviceList) {
                if (!s.getPackages().contains(pkg)) continue;
                serviceMap.put((Object)pkg.getName(), (Object)s);
            }
        }
        CSViewModel view = this.createView();
        view.addModel("PACKAGES", packageList);
        view.addModel("SERVICES", serviceMap);
        view.addModel("VERSIONS", versionMap);
        return view.render();
    }

    @Override
    @Transactional
    public RenderedView addPackageView(String pname, Long versionid) {
        RESTAssert.assertNotEmpty((String)pname);
        RESTAssert.assertNotNull((Object)versionid);
        EPackageVersion version = (EPackageVersion)this.dVersion.findById(versionid);
        List templates = this.dTemplate.findList();
        ArrayList<ETemplate> ts = new ArrayList<ETemplate>();
        for (ETemplate temp : templates) {
            if (temp.getPackageVersions().contains(version)) continue;
            ts.add(temp);
        }
        this.sortNamedList(ts);
        CSViewModel vm = this.createModal("mInstallPackage");
        vm.addModel("templates", ts);
        vm.addModel("version", version);
        return vm.render();
    }

    @Override
    @Transactional
    public AjaxAnswer addPackage(String pname, Long versionId, String[] templates) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)pname);
        RESTAssert.assertNotNull((Object)versionId);
        if (templates == null || templates.length < 1) {
            throw this.createError("Please select at least one template.");
        }
        EPackageVersion pv = (EPackageVersion)this.dVersion.findById(versionId);
        List services = this.dSvc.findList();
        block0: for (String temp : templates) {
            ETemplate t = (ETemplate)this.dTemplate.findByName(temp);
            if (t.getPackageVersions() == null) {
                t.setPackageVersions(new ArrayList<EPackageVersion>());
            }
            for (EPackageVersion existing : t.getPackageVersions()) {
                if (!existing.getPkg().equals(pv.getPkg())) continue;
                t.getPackageVersions().remove(existing);
                break;
            }
            t.getPackageVersions().add(pv);
            this.dTemplate.save(t);
            for (EService s : services) {
                if (!s.getPackages().contains(pv.getPkg())) continue;
                this.setDefaultService(s, t);
                continue block0;
            }
        }
        return new AjaxAnswer("/web/packages");
    }

    private void setDefaultService(EService service, ETemplate template) {
        EServiceDefaultState sds = this.dSvcDefState.findByName(service.getName(), template.getName());
        if (sds == null) {
            sds = new EServiceDefaultState();
            sds.setService(service);
            sds.setTemplate(template);
            sds.setState(ServiceState.STOPPED);
            this.dSvcDefState.save(sds);
        }
    }

    @Override
    @Transactional
    public RenderedView addServiceView(String pname) {
        RESTAssert.assertNotEmpty((String)pname);
        EPackage pkg = (EPackage)this.dPkg.findByName(pname);
        ArrayList<EService> serviceList = new ArrayList<EService>();
        for (EService s : this.dSvc.findList()) {
            if (s.getPackages().contains(pkg)) continue;
            serviceList.add(s);
        }
        this.sortNamedList(serviceList);
        CSViewModel modal = this.createModal("mAddService");
        modal.addModel("services", serviceList);
        modal.addModel("packageName", pname);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer addService(String pname, String[] services) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)pname);
        if (services == null || services.length < 1) {
            throw this.createError("Please select at least one service.");
        }
        EPackage pkg = (EPackage)this.dPkg.findByName(pname);
        for (String service : services) {
            EService eservice = (EService)this.dSvc.findByName(service);
            eservice.getPackages().add(pkg);
            this.dSvc.save(eservice);
        }
        return new AjaxAnswer("/web/packages#" + pname);
    }

    @Override
    @Transactional
    public RenderedView newServiceView(String pname) {
        CSViewModel modal = this.createModal("mNewService");
        modal.addModel("packageName", pname);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer newService(String pname, String servicename, String initscript, String description) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)pname);
        String errorMessage = "Please fill in all the information.";
        FormErrorException error = null;
        error = this.checkForEmpty(servicename, errorMessage, error, "servicename");
        error = this.checkForEmpty(initscript, errorMessage, error, "initscript");
        if (error != null) {
            error.addFormParam("servicename", servicename);
            error.addFormParam("initscript", initscript);
            error.addFormParam("description", description);
            throw error;
        }
        EPackage pkg = (EPackage)this.dPkg.findByName(pname);
        EService service = new EService();
        service.setName(servicename);
        service.setInitScript(initscript);
        service.setDescription(description);
        service.getPackages().add(pkg);
        service = (EService)this.dSvc.save(service);
        return new AjaxAnswer("/web/packages#" + pname);
    }

    @Override
    @Transactional
    public RenderedView deleteServiceView(String pname, String sname) {
        CSViewModel modal = this.createModal("mDeleteService");
        modal.addModel("packageName", pname);
        modal.addModel("serviceName", sname);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer deleteService(String pname, String sname) {
        RESTAssert.assertNotEmpty((String)pname);
        RESTAssert.assertNotEmpty((String)sname);
        EPackage pkgVersion = (EPackage)this.dPkg.findByName(pname);
        EService service = (EService)this.dSvc.findByName(sname);
        service.getPackages().remove(pkgVersion);
        this.dSvc.save(service);
        return new AjaxAnswer("/web/packages#" + pname);
    }
}

