/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.server.dao.IPackageServerDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EPackageServer;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.interfaces.IPackageServer;
import de.taimos.restutils.RESTAssert;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PackageServerImpl
extends AWebPage
implements IPackageServer {
    @Autowired
    private IPackageServerDAO dPckSrv;
    @Autowired
    private ITemplateDAO dTemplate;

    @Override
    protected String getTemplateFolder() {
        return "servers";
    }

    @Override
    protected void init() {
    }

    @Override
    protected String getNavElementName() {
        return "Package Servers";
    }

    @Override
    public RenderedView view() {
        CSViewModel modal = this.createModal("mServers");
        modal.addModel("servers", this.dPckSrv.findList());
        return modal.render();
    }

    @Override
    public RenderedView addServerView() {
        CSViewModel modal = this.createModal("mModServer");
        return modal.render();
    }

    @Override
    public RenderedView editServerView(Long serverid) {
        EPackageServer server = (EPackageServer)this.dPckSrv.findById(serverid);
        RESTAssert.assertNotNull((Object)server);
        CSViewModel modal = this.createModal("mModServer");
        modal.addModel("server", server);
        return modal.render();
    }

    @Override
    public RenderedView deleteServerView(Long serverid) {
        EPackageServer server = (EPackageServer)this.dPckSrv.findById(serverid);
        RESTAssert.assertNotNull((Object)server);
        CSViewModel modal = this.createModal("mDeleteServer");
        modal.addModel("server", server);
        return modal.render();
    }

    @Override
    public AjaxAnswer saveServer(Long serverid, String path, String description) throws FormErrorException {
        RESTAssert.assertNotNull((Object)serverid);
        FormErrorException error = null;
        error = this.assertNotEmpty(path, error, "path");
        error = this.assertNotEmpty(description, error, "description");
        if (error != null) {
            error.addFormParam("path", path);
            error.addFormParam("description", description);
            if (serverid > 0L) {
                error.setParentUrl("/pkgsrv", serverid.toString(), "/edit");
            } else {
                error.setParentUrl("/pkgsrv", "/add");
            }
            throw error;
        }
        EPackageServer server = (EPackageServer)this.dPckSrv.findById(serverid);
        if (server == null) {
            server = new EPackageServer();
        }
        server.setDescription(description);
        server.setPath(path);
        server = (EPackageServer)this.dPckSrv.save(server);
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/pkgsrv", AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully saved");
        return ajaxRedirect;
    }

    @Override
    public AjaxAnswer deleteServer(Long serverid) throws FormErrorException {
        RESTAssert.assertNotNull((Object)serverid);
        EPackageServer server = (EPackageServer)this.dPckSrv.findById(serverid);
        List<ETemplate> tmplt = this.dTemplate.findByPackageServer(serverid);
        if (tmplt != null && tmplt.size() > 0) {
            FormErrorException error = this.createError("The package server is still in use and can't be deleted");
            error.setParentUrl("/pkgsrv");
            throw error;
        }
        this.dPckSrv.delete(server);
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/pkgsrv", AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully deleted");
        return ajaxRedirect;
    }
}

