/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.server.comparators.StateComparator;
import de.cinovo.cloudconductor.server.comparators.StringMapComparator;
import de.cinovo.cloudconductor.server.comparators.VersionStringComparator;
import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackageState;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.interfaces.IHost;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HostImpl
extends AWebPage
implements IHost {
    private DateTimeFormatter germanFmt = DateTimeFormat.forPattern((String)"HH:mm:ss - dd.MM.yyyy");
    @Autowired
    protected IHostDAO dHost;

    @Override
    protected String getTemplateFolder() {
        return "hosts";
    }

    @Override
    protected void init() {
        this.navRegistry.registerMainMenu(this.getNavElementName(), "/hosts");
        this.addBreadCrumb("/web/hosts", this.getNavElementName());
    }

    @Override
    protected String getNavElementName() {
        return "Hosts";
    }

    @Override
    @Transactional
    public RenderedView view() {
        List eHosts = this.dHost.findList();
        HashMap<String, String[]> reporttimes = new HashMap<String, String[]>();
        HashMap<String, List<Map<String, Object>>> thDiff = new HashMap<String, List<Map<String, Object>>>();
        StateComparator comp = new StateComparator();
        for (EHost h : eHosts) {
            this.addSidebarElement(h.getName());
            Collections.sort(h.getServices(), comp);
            DateTime last = new DateTime((Object)h.getLastSeen());
            String diff = String.valueOf(Minutes.minutesBetween((ReadableInstant)last, (ReadableInstant)new DateTime()).getMinutes());
            reporttimes.put(h.getName(), new String[]{diff, this.germanFmt.print((ReadableInstant)last)});
            thDiff.put(h.getName(), this.createHostTemplateDiff(h));
        }
        this.sortNamedList(eHosts);
        CSViewModel view = this.createView();
        view.addModel("HOSTS", eHosts);
        view.addModel("DIFFERENCES", thDiff);
        return view.render();
    }

    @Override
    @Transactional
    public RenderedView view(String hname) {
        EHost eHosts = (EHost)this.dHost.findByName(hname);
        Collections.sort(eHosts.getServices(), new StateComparator());
        CSViewModel modal = this.createModal("mSingleView");
        modal.addModel("host", eHosts);
        modal.addModel("DIFFERENCES", this.createHostTemplateDiff(eHosts));
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer changeServiceStates(String hname, String[] start, String[] stop, String[] restart) {
        RESTAssert.assertNotEmpty((String)hname);
        if (start.length < 1 && stop.length < 1 && restart.length < 1) {
            new AjaxAnswer("/web/hosts");
        }
        EHost host = (EHost)this.dHost.findByName(hname);
        block0: for (String service : start) {
            for (EServiceState eservice : host.getServices()) {
                if (!eservice.getService().getName().equals(service)) continue;
                eservice.setState(ServiceState.STARTING);
                continue block0;
            }
        }
        block2: for (String service : stop) {
            for (EServiceState eservice : host.getServices()) {
                if (!eservice.getService().getName().equals(service)) continue;
                eservice.setState(ServiceState.STOPPING);
                continue block2;
            }
        }
        block4: for (String service : restart) {
            for (EServiceState eservice : host.getServices()) {
                if (!eservice.getService().getName().equals(service)) continue;
                eservice.setState(ServiceState.RESTARTING);
                continue block4;
            }
        }
        this.dHost.save(host);
        return new AjaxAnswer("/web/hosts");
    }

    @Override
    @Transactional
    public RenderedView deleteHostView(String hname) {
        RESTAssert.assertNotEmpty((String)hname);
        EHost host = (EHost)this.dHost.findByName(hname);
        RESTAssert.assertNotNull((Object)host);
        CSViewModel modal = this.createModal("mDeleteHost");
        modal.addModel("host", host);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer deleteHost(String hname) {
        RESTAssert.assertNotEmpty((String)hname);
        EHost host = (EHost)this.dHost.findByName(hname);
        if (host != null) {
            this.dHost.delete(host);
        }
        return new AjaxAnswer("/web/hosts");
    }

    private List<Map<String, Object>> createHostTemplateDiff(EHost h) {
        List<EPackageVersion> trpms = h.getTemplate().getPackageVersions();
        HashSet<EPackageVersion> missing = new HashSet<EPackageVersion>(trpms);
        VersionStringComparator versionComp = new VersionStringComparator();
        StringMapComparator mapComp = new StringMapComparator("name");
        ArrayList<Map<String, Object>> notices = new ArrayList<Map<String, Object>>();
        for (EPackageState ipkg : h.getPackages()) {
            if (trpms.contains(ipkg.getVersion())) {
                missing.remove(ipkg.getVersion());
                continue;
            }
            boolean found = false;
            for (EPackageVersion trpm : trpms) {
                if (!trpm.getPkg().getName().equals(ipkg.getVersion().getPkg().getName())) continue;
                HashMap<String, String> wrongVersion = new HashMap<String, String>();
                wrongVersion.put("name", ipkg.getVersion().getPkg().getName());
                wrongVersion.put("installed", ipkg.getVersion().getVersion());
                wrongVersion.put("template", trpm.getVersion());
                if (versionComp.compare(ipkg.getVersion().getVersion(), trpm.getVersion()) < 0) {
                    wrongVersion.put("state", "updating");
                } else {
                    wrongVersion.put("state", "downgrading");
                }
                found = true;
                notices.add(wrongVersion);
                missing.remove(trpm);
            }
            if (found) continue;
            HashMap<String, String> wrongVersion = new HashMap<String, String>();
            wrongVersion.put("name", ipkg.getVersion().getPkg().getName());
            wrongVersion.put("installed", ipkg.getVersion().getVersion());
            wrongVersion.put("template", "");
            wrongVersion.put("state", "uninstalling");
            notices.add(wrongVersion);
        }
        for (EPackageVersion trpm : missing) {
            HashMap<String, String> wrongVersion = new HashMap<String, String>();
            wrongVersion.put("name", trpm.getPkg().getName());
            wrongVersion.put("installed", "");
            wrongVersion.put("template", trpm.getVersion());
            wrongVersion.put("state", "installing");
            notices.add(wrongVersion);
        }
        Collections.sort(notices, mapComp);
        return notices;
    }
}

