/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IFileDataDAO;
import de.cinovo.cloudconductor.server.dao.IFileTagsDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EFileData;
import de.cinovo.cloudconductor.server.model.EFileTag;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.helper.SidebarType;
import de.cinovo.cloudconductor.server.web.interfaces.IFiles;
import de.taimos.restutils.RESTAssert;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class FilesImpl
extends AWebPage
implements IFiles {
    @Autowired
    protected IFileDAO dFile;
    @Autowired
    protected ITemplateDAO dTemplate;
    @Autowired
    protected IPackageDAO dPackage;
    @Autowired
    private IServiceDAO dService;
    @Autowired
    private IFileDataDAO dFileData;
    @Autowired
    private IFileTagsDAO dFileTags;

    @Override
    protected String getTemplateFolder() {
        return "files";
    }

    @Override
    protected void init() {
        this.navRegistry.registerSubMenu(NavbarHardLinks.config, this.getNavElementName(), "/files");
        this.addBreadCrumb("/web/files", this.getNavElementName());
        this.addTopAction("/web/files/add", "Create new File");
        this.addViewType("default", "Default", true);
        this.addViewType("template", "by Template", false);
    }

    @Override
    protected SidebarType getSidebarType() {
        return SidebarType.ALPHABETICAL;
    }

    @Override
    protected String getNavElementName() {
        return "Files";
    }

    @Override
    @Transactional
    public RenderedView view(String viewtype, String[] filter) {
        this.clearFilter();
        if (viewtype != null && viewtype.equals("template")) {
            return this.templateView();
        }
        return this.defaultView(filter);
    }

    @Transactional
    private RenderedView defaultView(String[] filter) {
        for (EFileTag t : this.dFileTags.findList()) {
            this.addFilter(String.valueOf(t.getId()), t.getName(), false);
        }
        ArrayList<EFileTag> tags = new ArrayList<EFileTag>();
        for (String string : filter) {
            EFileTag tag = (EFileTag)this.dFileTags.findById(Long.valueOf(string));
            if (tag == null) continue;
            tags.add(tag);
        }
        List daofiles = this.dFile.findList();
        ArrayList<EFile> files = new ArrayList<EFile>();
        for (EFile eFile : daofiles) {
            if (!tags.isEmpty()) {
                if (Collections.disjoint(eFile.getTags(), tags)) continue;
                this.addSidebarElement(eFile.getName());
                files.add(eFile);
                continue;
            }
            this.addSidebarElement(eFile.getName());
            files.add(eFile);
        }
        this.addSidebarElements(files);
        List templates = this.dTemplate.findList();
        this.sortNamedList(files);
        CSViewModel cSViewModel = this.createView();
        cSViewModel.addModel("FILES", files);
        cSViewModel.addModel("TEMPLATES", templates);
        return cSViewModel.render();
    }

    @Transactional
    private RenderedView templateView() {
        List files = this.dFile.findList();
        for (EFile f : files) {
            this.addSidebarElement(f.getName());
        }
        this.addSidebarElements(files);
        List templates = this.dTemplate.findList();
        this.sortNamedList(files);
        CSViewModel view = this.createView("viewTemplate");
        view.addModel("SIDEBARTYPE", null);
        view.addModel("FILES", files);
        view.addModel("TEMPLATES", templates);
        return view.render();
    }

    @Override
    @Transactional
    public RenderedView newFileView() {
        List packages = this.dPackage.findList();
        this.sortNamedList(packages);
        List services = this.dService.findList();
        this.sortNamedList(services);
        List templates = this.dTemplate.findList();
        this.sortNamedList(templates);
        CSViewModel modal = this.createModal("mModFile");
        modal.addModel("PACKAGES", packages);
        modal.addModel("SERVICES", services);
        modal.addModel("TEMPLATES", templates);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView editFileView(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile oldFile = (EFile)this.dFile.findByName(name);
        EFileData fileData = this.dFileData.findDataByFile(oldFile);
        List packages = this.dPackage.findList();
        List services = this.dService.findList();
        this.sortNamedList(services);
        this.sortNamedList(packages);
        List templates = this.dTemplate.findList();
        this.sortNamedList(templates);
        CSViewModel modal = this.createModal("mModFile");
        modal.addModel("FILE", oldFile);
        modal.addModel("FILEDATA", StringEscapeUtils.escapeHtml((String)fileData.getData()));
        modal.addModel("PACKAGES", packages);
        modal.addModel("SERVICES", services);
        modal.addModel("TEMPLATES", templates);
        return modal.render();
    }

    @Override
    public RenderedView deleteFileView(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile file = (EFile)this.dFile.findByName(name);
        CSViewModel modal = this.createModal("mDeleteFile");
        modal.addModel("FILE", file);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView deleteFileFromTemplateView(String name, String template) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)template);
        ETemplate t = (ETemplate)this.dTemplate.findByName(template);
        RESTAssert.assertNotNull((Object)t);
        EFile file = (EFile)this.dFile.findByName(name);
        RESTAssert.assertNotNull((Object)file);
        CSViewModel modal = this.createModal("mDeleteFileFromTemplate");
        modal.addModel("FILE", file);
        modal.addModel("TEMPLATE", t);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView addFileToTemplateView(String template) {
        RESTAssert.assertNotEmpty((String)template);
        ETemplate t = (ETemplate)this.dTemplate.findByName(template);
        RESTAssert.assertNotNull((Object)t);
        CSViewModel modal = this.createModal("mAddFile");
        List files = this.dFile.findList();
        modal.addModel("FILES", files);
        modal.addModel("TEMPLATE", t);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView addTemplateToFileView(String file) {
        RESTAssert.assertNotEmpty((String)file);
        EFile f = (EFile)this.dFile.findByName(file);
        RESTAssert.assertNotNull((Object)f);
        CSViewModel modal = this.createModal("mAddTemplate");
        List templates = this.dTemplate.findList();
        modal.addModel("FILE", f);
        modal.addModel("TEMPLATES", templates);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer saveFile(String oldname, String newname, String owner, String group, String mode, String targetPath, String content, Boolean isTemplate, String depPackage, String[] depServices, String[] templates) throws FormErrorException {
        RESTAssert.assertNotEmpty((String)oldname);
        EFile cf = (EFile)this.dFile.findByName(oldname);
        FormErrorException error = null;
        error = this.assertNotEmpty(newname, error, "name");
        error = this.assertNotEmpty(owner, error, "owner");
        error = this.assertNotEmpty(group, error, "group");
        error = this.assertNotEmpty(mode, error, "mode");
        error = this.assertNotEmpty(targetPath, error, "targetPath");
        error = this.assertNotEmpty(content, error, "file_content");
        error = this.assertNotEmpty(owner, error, "owner");
        if (!oldname.equals(newname) && this.dFile.findByName(newname) != null) {
            error = error == null ? this.createError("The service name already exists.") : error;
            error.addElementError("name", true);
        }
        if (newname != null && !newname.isEmpty() && newname.contains(" ")) {
            error = error == null ? this.createError("The service name may not contain spaces.") : error;
            error.addElementError("name", true);
        }
        if (error != null) {
            error.addFormParam("name", newname);
            error.addFormParam("owner", owner);
            error.addFormParam("group", group);
            error.addFormParam("mode", mode);
            error.addFormParam("targetPath", targetPath);
            error.addFormParam("file_content", content);
            error.addFormParam("isTemplate", isTemplate);
            error.addFormParam("depPackage", depPackage);
            error.addFormParam("depServices", Arrays.asList(depServices));
            error.addFormParam("templates", templates);
            if (oldname.equals("0")) {
                error.setParentUrl("/files", "/add");
            } else {
                error.setParentUrl("/files", oldname, "/edit");
            }
            throw error;
        }
        if (cf == null) {
            cf = new EFile();
            cf.setDependentServices(new ArrayList<EService>());
        }
        cf.setName(newname);
        cf.setOwner(owner);
        cf.setGroup(group);
        cf.setFileMode(mode);
        cf.setTargetPath(targetPath);
        cf.setTemplate(isTemplate != null);
        cf.setPkg((EPackage)this.dPackage.findByName(depPackage));
        if (depServices.length > 0) {
            cf.setReloadable(true);
            HashSet<EService> notfound = new HashSet<EService>(cf.getDependentServices());
            for (String service : depServices) {
                EService eservice = (EService)this.dService.findByName(service);
                if (!cf.getDependentServices().contains(eservice)) {
                    cf.getDependentServices().add(eservice);
                }
                notfound.remove(eservice);
            }
            cf.getDependentServices().removeAll(notfound);
        } else {
            cf.setReloadable(false);
            cf.getDependentServices().clear();
        }
        try {
            byte[] array = MessageDigest.getInstance("MD5").digest(content.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            cf.setChecksum(sb.toString());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            // empty catch block
        }
        cf = (EFile)this.dFile.save(cf);
        EFileData data = this.dFileData.findDataByFile(cf);
        if (data == null) {
            data = new EFileData();
            data.setParent(cf);
        }
        data.setData(content);
        data = (EFileData)this.dFileData.save(data);
        List notfound = this.dTemplate.findList();
        for (String template : templates) {
            ETemplate temp = (ETemplate)this.dTemplate.findByName(template);
            if (!temp.getConfigFiles().contains(cf)) {
                temp.getConfigFiles().add(cf);
                this.dTemplate.save(temp);
            }
            notfound.remove(temp);
        }
        for (ETemplate template : notfound) {
            if (!template.getConfigFiles().contains(cf)) continue;
            template.getConfigFiles().remove(cf);
            this.dTemplate.save(template);
        }
        return new AjaxAnswer("/web/files", this.getCurrentViewType());
    }

    @Override
    @Transactional
    public AjaxAnswer deleteFile(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile cf = (EFile)this.dFile.findByName(name);
        if (cf == null) {
            return new AjaxAnswer("/web/files");
        }
        EFileData data = this.dFileData.findDataByFile(cf);
        this.dFile.delete(cf);
        this.dFileData.delete(data);
        this.removeSidebarElement(name);
        return new AjaxAnswer("/web/files");
    }

    @Override
    @Transactional
    public AjaxAnswer deleteFileFromTemplate(String name, String template) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)name);
        ETemplate t = (ETemplate)this.dTemplate.findByName(template);
        EFile file = (EFile)this.dFile.findByName(name);
        if (t.getConfigFiles().contains(file)) {
            t.getConfigFiles().remove(file);
            this.dTemplate.save(t);
        }
        return new AjaxAnswer("/web/files", "template#" + template);
    }

    @Override
    @Transactional
    public AjaxAnswer addFileToTemplate(String[] name, String template) {
        RESTAssert.assertNotEmpty((String)template);
        ETemplate t = (ETemplate)this.dTemplate.findByName(template);
        for (String file : name) {
            EFile f = (EFile)this.dFile.findByName(file);
            t.getConfigFiles().add(f);
            this.dTemplate.save(t);
        }
        return new AjaxAnswer("/web/files", "template#" + template);
    }

    @Override
    @Transactional
    public AjaxAnswer addTemplateToFile(String[] template, String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile f = (EFile)this.dFile.findByName(name);
        for (String temp : template) {
            ETemplate t = (ETemplate)this.dTemplate.findByName(temp);
            t.getConfigFiles().add(f);
            this.dTemplate.save(t);
        }
        return new AjaxAnswer("/web/files", "template#" + template);
    }
}

