/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IFileTagsDAO;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EFileTag;
import de.cinovo.cloudconductor.server.model.enums.TagColor;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.interfaces.IFileTags;
import de.taimos.restutils.RESTAssert;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class FileTagsImpl
extends AWebPage
implements IFileTags {
    @Autowired
    protected IFileDAO dFiles;
    @Autowired
    protected IFileTagsDAO dTags;

    @Override
    protected String getTemplateFolder() {
        return "filetags";
    }

    @Override
    protected void init() {
    }

    @Override
    protected String getNavElementName() {
        return null;
    }

    @Override
    @Transactional
    public RenderedView viewFilesTags(Long fileid) {
        RESTAssert.assertNotNull((Object)fileid);
        EFile file = (EFile)this.dFiles.findById(fileid);
        List tags = this.dTags.findList();
        CSViewModel modal = this.createModal("mManageTags");
        modal.addModel("FILE", file);
        modal.addModel("TAGS", tags);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView newTagView(Long fileid) {
        CSViewModel modal = this.createModal("mNewTags");
        modal.addModel("TAGTYPES", TagColor.values());
        modal.addModel("FILEID", fileid);
        return modal.render();
    }

    @Override
    @Transactional
    public RenderedView deleteTagView(Long fileid, Long tagid) {
        EFileTag tag = (EFileTag)this.dTags.findById(tagid);
        List<EFile> files = this.dFiles.findByTag(tag);
        CSViewModel modal = this.createModal("mDeleteTag");
        modal.addModel("FILES", files);
        modal.addModel("TAG", tag);
        modal.addModel("FILEID", fileid);
        return modal.render();
    }

    @Override
    @Transactional
    public AjaxAnswer saveTaggedFile(Long fileid, Long[] tags) throws FormErrorException {
        EFile file = (EFile)this.dFiles.findById(fileid);
        file.getTags().clear();
        if (tags != null && tags.length > 0) {
            List<EFileTag> tag = this.dTags.findByIds(tags);
            file.setTags(tag);
        }
        this.dFiles.save(file);
        return new AjaxAnswer("/web/files", this.getCurrentViewType());
    }

    @Override
    @Transactional
    public AjaxAnswer saveNewTag(Long fileid, String name, String type) throws FormErrorException {
        FormErrorException error = null;
        error = this.assertNotEmpty(name, error, "name");
        if ((error = this.assertNotEmpty(type, error, "type")) != null) {
            error.addFormParam("name", name);
            error.addFormParam("type", type);
            error.setParentUrl("/tags");
            throw error;
        }
        EFileTag tag = new EFileTag();
        tag.setName(name);
        tag.setColor(TagColor.valueOf(type));
        this.dTags.save(tag);
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/tags/" + fileid, AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully added");
        return ajaxRedirect;
    }

    @Override
    @Transactional
    public AjaxAnswer deleteTag(Long fileid, Long tagid) throws FormErrorException {
        EFileTag tag = (EFileTag)this.dTags.findById(tagid);
        List<EFile> files = this.dFiles.findByTag(tag);
        for (EFile f : files) {
            f.getTags().remove(tag);
            this.dFiles.save(f);
        }
        this.dTags.delete(tag);
        AjaxAnswer ajaxRedirect = new AjaxAnswer("/web/tags/" + fileid, AjaxAnswer.AjaxAnswerType.GET);
        ajaxRedirect.setInfo("Successfully deleted");
        return ajaxRedirect;
    }
}

