/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.cinovo.cloudconductor.server.comparators.ConfigComperator;
import de.cinovo.cloudconductor.server.dao.IConfigValueDAO;
import de.cinovo.cloudconductor.server.model.EConfigValue;
import de.cinovo.cloudconductor.server.util.FormErrorException;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.AjaxAnswer;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.interfaces.IConfig;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ConfigImpl
extends AWebPage
implements IConfig {
    @Autowired
    protected IConfigValueDAO dConfig;

    @Override
    protected String getTemplateFolder() {
        return "config";
    }

    @Override
    protected void init() {
        this.navRegistry.registerSubMenu(NavbarHardLinks.config, this.getNavElementName(), "/config");
        this.addBreadCrumb("/web/config", this.getNavElementName());
        this.addTopAction("/web/config/add", "Create new Key");
        this.addTopAction("/web/config/batchmod", "Batch modify");
    }

    private String templateNormer(String template) {
        return template.trim().replace(" ", "_");
    }

    @Override
    protected String getNavElementName() {
        return "Config";
    }

    @Override
    @Transactional
    public RenderedView view(String viewtype) {
        this.clearViewType();
        for (String template : this.dConfig.findTemplates()) {
            if (template.equals("GLOBAL")) {
                this.addViewType(template, template, true);
                continue;
            }
            this.addViewType(this.templateNormer(template), template, false);
        }
        String template = viewtype == null ? "GLOBAL" : viewtype;
        List<EConfigValue> configs = this.dConfig.findAll(template);
        HashMap conf = new HashMap();
        for (EConfigValue val : configs) {
            String service = val.getService();
            if (service != null && service.isEmpty()) {
                service = null;
            }
            if (!conf.containsKey(service)) {
                conf.put(service, new ArrayList());
            }
            ((List)conf.get(service)).add(val);
        }
        ConfigComperator comperator = new ConfigComperator();
        for (Map.Entry a : conf.entrySet()) {
            Collections.sort((List)a.getValue(), comperator);
        }
        CSViewModel view = this.createView();
        view.addModel("CONFIGS", this.sortMap(conf));
        view.addModel("TEMPLATE", template);
        return view.render();
    }

    @Override
    public RenderedView deleteConfigView(String id) {
        RESTAssert.assertNotEmpty((String)id);
        EConfigValue config = (EConfigValue)this.dConfig.findById(Long.valueOf(id));
        RESTAssert.assertNotNull((Object)config);
        CSViewModel modal = this.createModal("mDeleteConfig");
        modal.addModel("CONFIG", config);
        return modal.render();
    }

    @Override
    public RenderedView deleteTemplateView(String template) {
        RESTAssert.assertNotNull((Object)template);
        CSViewModel modal = this.createModal("mDeleteConfig");
        modal.addModel("TEMPLATE", template);
        return modal.render();
    }

    @Override
    public RenderedView deleteServiceView(String template, String service) {
        RESTAssert.assertNotNull((Object)template);
        CSViewModel modal = this.createModal("mDeleteConfig");
        modal.addModel("TEMPLATE", template);
        modal.addModel("SERVICE", service);
        return modal.render();
    }

    @Override
    public RenderedView editConfigView(String id) {
        RESTAssert.assertNotEmpty((String)id);
        EConfigValue config = (EConfigValue)this.dConfig.findById(Long.valueOf(id));
        RESTAssert.assertNotNull((Object)config);
        CSViewModel modal = this.createModal("mModConfig");
        modal.addModel("CONFIG", config);
        return modal.render();
    }

    @Override
    public RenderedView addConfigView() {
        CSViewModel modal = this.createModal("mModConfig");
        return modal.render();
    }

    @Override
    public RenderedView addConfigView(String template) {
        RESTAssert.assertNotNull((Object)template);
        CSViewModel modal = this.createModal("mModConfig");
        modal.addModel("TEMPLATE", template);
        return modal.render();
    }

    @Override
    public RenderedView addConfigView(String template, String service) {
        RESTAssert.assertNotNull((Object)template);
        RESTAssert.assertNotNull((Object)service);
        CSViewModel modal = this.createModal("mModConfig");
        modal.addModel("TEMPLATE", template);
        modal.addModel("SERVICE", service);
        return modal.render();
    }

    @Override
    public RenderedView batchModView() {
        List total = this.dConfig.findList();
        StringBuffer buffer = new StringBuffer();
        for (EConfigValue value : total) {
            buffer.append("#+/");
            buffer.append(value.getTemplate());
            buffer.append("/");
            buffer.append(value.getService());
            buffer.append("/");
            buffer.append(value.getConfigkey());
            buffer.append("=");
            buffer.append(value.getValue());
            buffer.append(System.lineSeparator());
        }
        CSViewModel modal = this.createModal("mBatchMod");
        modal.addModel("BATCHDEFAULT", buffer.toString());
        return modal.render();
    }

    @Override
    public AjaxAnswer save(String oldId, String template, String service, String key, String value) throws FormErrorException {
        EConfigValue config;
        FormErrorException error = null;
        error = this.assertNotEmpty(template, error, "template");
        error = this.assertNotEmpty(key, error, "key");
        error = this.assertNotEmpty(value, error, "value");
        EConfigValue eConfigValue = config = oldId == null || Long.valueOf(oldId) < 1L ? null : (EConfigValue)this.dConfig.findById(Long.valueOf(oldId));
        if (config == null || !config.getConfigkey().equals(key)) {
            if (service != null && !service.isEmpty() && this.dConfig.findBy(template, service, key) != null) {
                error = error == null ? this.createError("The key already exists.") : error;
                error.addElementError("key", true);
            } else if (this.dConfig.findKey(template, key) != null) {
                error = error == null ? this.createError("The key already exists.") : error;
                error.addElementError("key", true);
            }
        }
        if (error != null) {
            error.addFormParam("oldId", oldId);
            error.addFormParam("template", template);
            error.addFormParam("service", service);
            error.addFormParam("key", key);
            error.addFormParam("value", value);
            if (oldId != null && oldId.equals("0")) {
                error.setParentUrl("/config", "/add");
            } else {
                error.setParentUrl("/config", oldId, "/edit");
            }
            throw error;
        }
        if (config == null) {
            config = new EConfigValue();
        }
        config.setTemplate(template);
        config.setService(service == null || service.isEmpty() ? null : service);
        config.setConfigkey(key);
        config.setValue(value);
        this.dConfig.save(config);
        this.addViewType(template, template, false);
        return new AjaxAnswer("/web/config", template);
    }

    @Override
    public AjaxAnswer deleteConfig(String id) {
        RESTAssert.assertNotEmpty((String)id);
        EConfigValue config = (EConfigValue)this.dConfig.findById(Long.valueOf(id));
        RESTAssert.assertNotNull((Object)config);
        String auditMessage = "Removed config " + config.getConfigkey() + " from template " + config.getTemplate() + " and service " + config.getService();
        this.dConfig.delete(config, auditMessage);
        return new AjaxAnswer("/web/config", config.getTemplate());
    }

    @Override
    public AjaxAnswer deleteTemplate(String template) {
        RESTAssert.assertNotEmpty((String)template);
        List<EConfigValue> found = this.dConfig.findAll(template);
        for (EConfigValue cv : found) {
            this.dConfig.delete(cv, "Removed template " + template);
        }
        return new AjaxAnswer("/web/config", "GLOBAL");
    }

    @Override
    public AjaxAnswer deleteService(String template, String service) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)service);
        List<EConfigValue> found = this.dConfig.findBy(template, service);
        for (EConfigValue cv : found) {
            this.dConfig.delete(cv, "Removed service " + service + " of template " + template);
        }
        return new AjaxAnswer("/web/config");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AjaxAnswer batchMod(String batch) {
        RESTAssert.assertNotEmpty((String)batch);
        HashMap<String, String> drop = new HashMap<String, String>();
        HashBasedTable remove = HashBasedTable.create();
        HashBasedTable add = HashBasedTable.create();
        Throwable throwable = null;
        try (Scanner sc = new Scanner(batch);){
            while (sc.hasNextLine()) {
                String[] line = sc.nextLine().split("/", 4);
                if (line == null || line.length < 2 || line[0].startsWith("#")) continue;
                if (line.length < 3) {
                    String[] stringArray = new String[]{line[0], line[1], ""};
                    line = stringArray;
                }
                String[] stringArray = new String[2];
                if (line.length >= 4 && !line[3].isEmpty()) {
                    if (line[3].contains("=")) {
                        String[] stringArray2 = line[3].split("=", 2);
                    } else {
                        stringArray[0] = line[3];
                    }
                }
                switch (line[0]) {
                    case "DROP": {
                        drop.put(line[1], line[2]);
                        break;
                    }
                    case "-": {
                        void var8_17;
                        if (var8_17[0] == null || var8_17[0].isEmpty()) {
                            drop.put(line[1], line[2]);
                            break;
                        }
                        if (remove.get((Object)line[1], (Object)line[2]) == null) {
                            remove.put((Object)line[1], (Object)line[2], new HashSet());
                        }
                        ((Set)remove.get((Object)line[1], (Object)line[2])).add(var8_17[0]);
                        break;
                    }
                    case "+": {
                        void var8_17;
                        if (add.get((Object)line[1], (Object)line[2]) == null) {
                            add.put((Object)line[1], (Object)line[2], new HashMap());
                        }
                        ((Map)add.get((Object)line[1], (Object)line[2])).put(var8_17[0], var8_17[1]);
                        break;
                    }
                }
            }
        }
        catch (Throwable x2) {
            Throwable throwable2 = x2;
            throw x2;
        }
        for (Map.Entry entry : drop.entrySet()) {
            for (EConfigValue eConfigValue : this.dConfig.findBy((String)entry.getKey(), (String)entry.getValue())) {
                this.dConfig.delete(eConfigValue);
            }
        }
        for (Table.Cell cell : remove.cellSet()) {
            for (EConfigValue eConfigValue : this.dConfig.findBy((String)cell.getRowKey(), (String)cell.getColumnKey())) {
                if (!((Set)cell.getValue()).contains(eConfigValue.getConfigkey())) continue;
                this.dConfig.delete(eConfigValue);
            }
        }
        for (Table.Cell cell : add.cellSet()) {
            for (Map.Entry entry : ((Map)cell.getValue()).entrySet()) {
                EConfigValue ecv = this.dConfig.findBy((String)cell.getRowKey(), (String)cell.getColumnKey(), (String)entry.getKey());
                if (ecv == null) {
                    ecv = new EConfigValue();
                    ecv.setTemplate((String)cell.getRowKey());
                    ecv.setService((String)cell.getColumnKey());
                    ecv.setConfigkey((String)entry.getKey());
                }
                ecv.setValue((String)entry.getValue());
                this.dConfig.save(ecv);
            }
        }
        return new AjaxAnswer("/web/config");
    }
}

