/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.impl;

import com.google.common.collect.Lists;
import de.cinovo.cloudconductor.server.dao.IAuditLogDAO;
import de.cinovo.cloudconductor.server.model.EAuditLog;
import de.cinovo.cloudconductor.server.model.enums.AuditCategory;
import de.cinovo.cloudconductor.server.model.enums.AuditType;
import de.cinovo.cloudconductor.server.web.CSViewModel;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.cinovo.cloudconductor.server.web.helper.AWebPage;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import de.cinovo.cloudconductor.server.web.interfaces.IAudit;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditImpl
extends AWebPage
implements IAudit {
    @Autowired
    private IAuditLogDAO dAuditLog;

    @Override
    protected String getTemplateFolder() {
        return "audit";
    }

    @Override
    protected void init() {
        this.navRegistry.registerSubMenu(NavbarHardLinks.options, this.getNavElementName(), "/audit", 100);
    }

    @Override
    protected String getNavElementName() {
        return "Audit";
    }

    @Override
    public RenderedView view() {
        List audits = this.dAuditLog.findList();
        ArrayList<String> auditTypes = new ArrayList<String>();
        ArrayList<String> auditCategory = new ArrayList<String>();
        ArrayList<String> usernames = new ArrayList<String>();
        audits = Lists.reverse((List)audits);
        for (EAuditLog audit : audits) {
            if (usernames.contains(audit.getUsername())) continue;
            usernames.add(audit.getUsername());
        }
        for (AuditType auditType : AuditType.values()) {
            auditTypes.add(auditType.name());
        }
        for (Enum enum_ : AuditCategory.values()) {
            auditCategory.add(enum_.name());
        }
        CSViewModel vm = this.createView();
        vm.addModel("audits", audits);
        vm.addModel("audittypes", auditTypes);
        vm.addModel("auditcategory", auditCategory);
        vm.addModel("users", usernames);
        return vm.render();
    }
}

