/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import de.cinovo.cloudconductor.server.dao.IAdditionalLinksDAO;
import de.cinovo.cloudconductor.server.model.EAdditionalLinks;
import de.cinovo.cloudconductor.server.web.helper.NavbarElement;
import de.cinovo.cloudconductor.server.web.helper.NavbarHardLinks;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NavbarRegistry {
    @Autowired
    protected IAdditionalLinksDAO dLinks;
    private TreeSet<NavbarElement> mainMenu = new TreeSet();
    private Multimap<NavbarHardLinks, NavbarElement> subMenu = TreeMultimap.create();

    @PostConstruct
    public void init() {
        List links = this.dLinks.findList();
        int counter = 0;
        for (EAdditionalLinks link : links) {
            this.registerSubMenu(NavbarHardLinks.links, link.getLabel(), link.getUrl(), counter++);
        }
        this.subMenu.put((Object)NavbarHardLinks.options, (Object)new NavbarElement(null, null));
    }

    public void registerMainMenu(String identifier, String relativePath) {
        this.mainMenu.add(new NavbarElement(identifier, relativePath));
    }

    public void registerSubMenu(NavbarHardLinks menu, String identifier, String relativePath) {
        this.subMenu.put((Object)menu, (Object)new NavbarElement(identifier, relativePath));
    }

    public void unregisterSubMenu(NavbarHardLinks menu, String identifier) {
        this.subMenu.get((Object)menu).remove(new NavbarElement(identifier, null));
    }

    public void registerMainMenu(String identifier, String relativePath, int orderNo) {
        this.mainMenu.add(new NavbarElement(identifier, relativePath, orderNo));
    }

    public void registerSubMenu(NavbarHardLinks menu, String identifier, String relativePath, int orderNo) {
        this.subMenu.put((Object)menu, (Object)new NavbarElement(identifier, relativePath, orderNo));
    }

    public TreeSet<NavbarElement> getMainMenu() {
        return this.mainMenu;
    }

    public Set<NavbarHardLinks> getSubMenuCategories() {
        return this.subMenu.keySet();
    }

    public Collection<NavbarElement> getSubMenu(NavbarHardLinks category) {
        return this.subMenu.get((Object)category);
    }
}

