/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.web;

import de.cinovo.cloudconductor.server.model.EServerOptions;
import de.cinovo.cloudconductor.server.web.RenderedView;
import de.taimos.cxf_renderer.model.ViewModel;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.SortTool;
import org.joda.time.DateTime;

public class CSViewModel
extends ViewModel {
    public static final String MODAL_IDENTIFIER = "_MODAL_";

    private static String evaluateVM(String name, Map<String, Object> variables) {
        try {
            VelocityContext context = new VelocityContext();
            Set<Map.Entry<String, Object>> entrySet = variables.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                context.put(entry.getKey(), entry.getValue());
            }
            Template template = Velocity.getTemplate((String)name);
            StringWriter w = new StringWriter();
            template.merge((Context)context, (Writer)w);
            return w.toString();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public CSViewModel(String viewName, boolean isModal, EServerOptions options) {
        super(viewName);
        this.addModel("C2InstanceOptions", options);
        String implementationVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        this.addModel("C2InstanceVersion", implementationVersion != null ? implementationVersion : "DEV-SNAPSHOT");
        if (isModal) {
            this.addModel("VIEWNAME", MODAL_IDENTIFIER + viewName);
        } else {
            this.addModel("VIEWNAME", viewName);
        }
        this.addModel("dateTool", new DateTool());
        this.addModel("sorterTool", new SortTool());
        this.addModel("NOW", DateTime.now());
    }

    protected String generateTemplateName() {
        if (this.getViewName().startsWith(MODAL_IDENTIFIER)) {
            String view = this.getViewName().substring(MODAL_IDENTIFIER.length(), this.getViewName().length());
            return "/web/pages/" + view + ".vm";
        }
        return "/web/index.vm";
    }

    public RenderedView render() {
        RenderedView view = new RenderedView();
        String evaluateVM = CSViewModel.evaluateVM(this.generateTemplateName(), this.getModel());
        view.setContent(evaluateVM);
        return view;
    }

    static {
        try {
            Velocity.setProperty((String)"resource.loader", (Object)"class");
            Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)Log4JLogChute.class.getCanonicalName());
            Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"org.apache.velocity");
            Velocity.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

