/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormErrorException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String parentUrl;
    private Map<String, Object> formParams = new HashMap<String, Object>();
    private Set<String> failedElements = new HashSet<String>();

    public void setParentUrl(String ... parts) {
        StringBuilder b = new StringBuilder();
        for (String p : parts) {
            if (!p.startsWith("/")) {
                b.append("/");
            }
            b.append(p);
        }
        this.parentUrl = b.toString();
    }

    public FormErrorException(String parentUrl, String msg) {
        super(msg);
        this.parentUrl = parentUrl;
    }

    public String getParentUrl() {
        return this.parentUrl;
    }

    public Map<String, Object> getFormParams() {
        return this.formParams;
    }

    public void addFormParam(String elementName, Object value) {
        this.formParams.put(elementName, value);
    }

    public void addFormParam(String elementName, Object value, boolean failed) {
        this.formParams.put(elementName, value);
        if (failed) {
            this.failedElements.add(elementName);
        }
    }

    public void addElementError(String elementName, boolean failed) {
        if (failed) {
            this.failedElements.add(elementName);
        }
    }

    public boolean hasError(String elementName) {
        return this.failedElements.contains(elementName);
    }
}

