/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.util;

import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.model.EHost;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cleanuptask")
public class CleanUpTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpTask.class);
    private static final int MAX_AGE = 180;
    @Autowired
    private IHostDAO dhost;

    @Override
    public void run() {
        if (this.dhost == null) {
            LOGGER.debug("Couldn't get the host dao injected");
            return;
        }
        List hosts = this.dhost.findList();
        HashSet<EHost> delete = new HashSet<EHost>();
        for (EHost host : hosts) {
            DateTime now = new DateTime();
            DateTime dt = new DateTime((Object)host.getLastSeen());
            int diff = Minutes.minutesBetween((ReadableInstant)dt, (ReadableInstant)now).getMinutes();
            if (diff <= 180) continue;
            delete.add(host);
        }
        for (EHost host : delete) {
            this.dhost.delete(host);
        }
    }
}

