/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.ITemplate;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.Template;
import de.cinovo.cloudconductor.server.comparators.PackageVersionComparator;
import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.ISSHKeyDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDefaultStateDAO;
import de.cinovo.cloudconductor.server.dao.IServiceStateDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ESSHKey;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class TemplateImpl
extends ImplHelper
implements ITemplate {
    @Autowired
    private ITemplateDAO dtemplate;
    @Autowired
    private IPackageVersionDAO drpm;
    @Autowired
    private IHostDAO dhost;
    @Autowired
    private IServiceDAO dsvc;
    @Autowired
    private IServiceStateDAO dsst;
    @Autowired
    private IServiceDefaultStateDAO ddsst;
    @Autowired
    private ISSHKeyDAO dssh;
    @Autowired
    private IFileDAO dcf;
    @Autowired
    private AMConverter amc;
    private PackageVersionComparator rpmComp = new PackageVersionComparator();

    @Transactional
    public Template[] get() {
        HashSet<Template> result = new HashSet<Template>();
        for (ETemplate m : this.dtemplate.findList()) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new Template[result.size()]);
    }

    @Transactional
    public void save(String name, Template apiObject) {
        this.assertName(name, (INamed)apiObject);
        ETemplate model = this.amc.toModel(apiObject);
        if (apiObject.getRpms() != null && !apiObject.getRpms().isEmpty()) {
            ArrayList<EPackageVersion> found = new ArrayList<EPackageVersion>();
            for (Map.Entry s : apiObject.getRpms().entrySet()) {
                EPackageVersion rpm = this.drpm.find((String)s.getKey(), (String)s.getValue());
                this.assertModelFound(rpm);
                found.add(rpm);
            }
            model.setPackageVersions(found);
        } else {
            model.setPackageVersions(null);
        }
        if (apiObject.getHosts() != null && !apiObject.getHosts().isEmpty()) {
            model.setHosts(this.findByName(this.dhost, apiObject.getHosts()));
        } else {
            model.setHosts(null);
        }
        if (apiObject.getSshkeys() != null && !apiObject.getSshkeys().isEmpty()) {
            model.setSshkeys(this.findByName(this.dssh, apiObject.getSshkeys()));
        } else {
            model.setSshkeys(null);
        }
        if (apiObject.getConfigFiles() != null && !apiObject.getConfigFiles().isEmpty()) {
            model.setConfigFiles(this.findByName(this.dcf, apiObject.getConfigFiles()));
        } else {
            model.setConfigFiles(null);
        }
        this.dtemplate.save(model);
    }

    @Transactional
    public Template get(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = this.findByName(this.dtemplate, name);
        return MAConverter.fromModel(model);
    }

    @Transactional
    public void delete(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = (ETemplate)this.dtemplate.findByName(name);
        this.assertModelFound(model);
        this.dtemplate.delete(model);
    }

    @Transactional
    public Host[] getHosts(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = this.findByName(this.dtemplate, name);
        HashSet<Host> result = new HashSet<Host>();
        for (EHost p : model.getHosts()) {
            result.add(MAConverter.fromModel(p));
        }
        return result.toArray(new Host[result.size()]);
    }

    @Transactional
    public void addHost(String name, String host) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)host);
        ETemplate model = this.findByName(this.dtemplate, name);
        EHost element = this.findByName(this.dhost, host);
        model.getHosts().add(element);
        this.dtemplate.save(model);
    }

    @Transactional
    public void removeHost(String name, String host) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)host);
        ETemplate model = this.findByName(this.dtemplate, name);
        EHost element = this.findByName(this.dhost, host);
        model.getHosts().remove(element);
        this.dtemplate.save(model);
    }

    @Transactional
    public SSHKey[] getSSHKeys(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = this.findByName(this.dtemplate, name);
        HashSet<SSHKey> result = new HashSet<SSHKey>();
        for (ESSHKey p : model.getSshkeys()) {
            result.add(MAConverter.fromModel(p));
        }
        return result.toArray(new SSHKey[result.size()]);
    }

    @Transactional
    public void addSSHKey(String name, String key) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)key);
        ETemplate model = this.findByName(this.dtemplate, name);
        ESSHKey element = this.findByName(this.dssh, key);
        model.getSshkeys().add(element);
        this.dtemplate.save(model);
    }

    @Transactional
    public void removeSSHKey(String name, String key) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)key);
        ETemplate model = this.findByName(this.dtemplate, name);
        ESSHKey element = this.findByName(this.dssh, key);
        model.getSshkeys().remove(element);
        this.dtemplate.save(model);
    }

    @Transactional
    public PackageVersion[] getRPMS(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = this.findByName(this.dtemplate, name);
        HashSet<PackageVersion> result = new HashSet<PackageVersion>();
        for (EPackageVersion p : model.getPackageVersions()) {
            result.add(MAConverter.fromModel(p));
        }
        return result.toArray(new PackageVersion[result.size()]);
    }

    @Transactional
    public void addRPM(String name, PackageVersion rpm) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotNull((Object)rpm);
        ETemplate model = this.findByName(this.dtemplate, name);
        this.assertModelFound(model);
        EPackageVersion erpm = null;
        if (rpm.getVersion() == null || rpm.getVersion().isEmpty()) {
            List<EPackageVersion> rpms = this.drpm.find(rpm.getName());
            Collections.sort(rpms, this.rpmComp);
            erpm = rpms.get(rpms.size() - 1);
        } else {
            erpm = this.drpm.find(rpm.getName(), rpm.getVersion());
        }
        this.assertModelFound(erpm);
        boolean exists = false;
        for (EPackageVersion r : model.getPackageVersions()) {
            if (!r.getPkg().getName().equals(erpm.getPkg().getName())) continue;
            if (r.getVersion().equals(erpm.getVersion())) {
                exists = true;
                break;
            }
            model.getPackageVersions().remove(r);
            break;
        }
        if (!exists) {
            model.getPackageVersions().add(erpm);
            this.dtemplate.save(model);
        }
    }

    @Transactional
    public void removeRPM(String name, String pkg, String version) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotNull((Object)pkg);
        RESTAssert.assertNotNull((Object)version);
        ETemplate model = this.findByName(this.dtemplate, name);
        EPackageVersion erpm = this.drpm.find(pkg, version);
        this.assertModelFound(erpm);
        model.getPackageVersions().remove(erpm);
        model = (ETemplate)this.dtemplate.save(model);
        for (EHost host : model.getHosts()) {
            for (EServiceState service : host.getServices()) {
                if (!service.getService().getPackages().contains(erpm.getPkg())) continue;
                this.ddsst.delete(this.ddsst.findByName(service.getService().getName(), model.getName()));
                this.dsst.delete(service);
            }
        }
    }

    @Transactional
    public Service[] getServices(String name) {
        RESTAssert.assertNotEmpty((String)name);
        ETemplate model = this.findByName(this.dtemplate, name);
        List services = this.dsvc.findList();
        HashSet<Service> result = new HashSet<Service>();
        for (EService s : services) {
            for (EPackageVersion p : model.getPackageVersions()) {
                if (!s.getPackages().contains(p.getPkg())) continue;
                result.add(MAConverter.fromModel(s));
            }
        }
        return result.toArray(new Service[result.size()]);
    }
}

