/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.IService;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl
extends ImplHelper
implements IService {
    @Autowired
    private IServiceDAO dservice;
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private AMConverter amc;

    @Transactional
    public Service[] get() {
        HashSet<Service> result = new HashSet<Service>();
        for (EService m : this.dservice.findList()) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new Service[result.size()]);
    }

    @Transactional
    public void save(String name, Service apiObject) {
        this.assertName(name, (INamed)apiObject);
        EService model = this.amc.toModel(apiObject);
        if (apiObject.getPackages() != null && !apiObject.getPackages().isEmpty()) {
            model.setPackages(this.findByName(this.dpkg, apiObject.getPackages()));
        } else {
            model.setPackages(null);
        }
        this.dservice.save(model);
    }

    @Transactional
    public Service get(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EService model = this.findByName(this.dservice, name);
        return MAConverter.fromModel(model);
    }

    @Transactional
    public void delete(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EService model = (EService)this.dservice.findByName(name);
        this.assertModelFound(model);
        this.dservice.delete(model);
    }

    @Transactional
    public Package[] getPackages(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EService service = this.findByName(this.dservice, name);
        HashSet<Package> result = new HashSet<Package>();
        for (EPackage p : service.getPackages()) {
            result.add(MAConverter.fromModel(p));
        }
        return result.toArray(new Package[result.size()]);
    }

    @Transactional
    public void addPackage(String name, String pkg) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)pkg);
        EService service = this.findByName(this.dservice, name);
        EPackage p = this.findByName(this.dpkg, pkg);
        service.getPackages().add(p);
        this.dservice.save(service);
    }

    @Transactional
    public void removePackage(String name, String pkg) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotNull((Object)pkg);
        EService service = this.findByName(this.dservice, name);
        EPackage p = this.findByName(this.dpkg, pkg);
        service.getPackages().remove(p);
        this.dservice.save(service);
    }
}

