/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.ISSHKey;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.server.dao.ISSHKeyDAO;
import de.cinovo.cloudconductor.server.model.ESSHKey;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SSHKeyImpl
extends ImplHelper
implements ISSHKey {
    @Autowired
    private ISSHKeyDAO dsshkey;
    @Autowired
    private AMConverter amc;

    @Transactional
    public SSHKey[] get() {
        HashSet<SSHKey> result = new HashSet<SSHKey>();
        for (ESSHKey t : this.dsshkey.findList()) {
            result.add(MAConverter.fromModel(t));
        }
        return result.toArray(new SSHKey[result.size()]);
    }

    @Transactional
    public void save(String name, SSHKey sshKey) {
        this.assertName(name, (INamed)sshKey);
        ESSHKey key = this.amc.toModel(sshKey);
        this.dsshkey.save(key);
    }

    @Transactional
    public SSHKey get(String owner) {
        RESTAssert.assertNotEmpty((String)owner);
        ESSHKey key = this.dsshkey.findByOwner(owner);
        this.assertModelFound(key);
        return MAConverter.fromModel(key);
    }

    @Transactional
    public void delete(String owner) {
        RESTAssert.assertNotEmpty((String)owner);
        ESSHKey key = this.dsshkey.findByOwner(owner);
        this.assertModelFound(key);
        this.dsshkey.delete(key);
    }
}

