/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.IPackage;
import de.cinovo.cloudconductor.api.model.Dependency;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.server.dao.IDependencyDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PackageImpl
extends ImplHelper
implements IPackage {
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private IPackageVersionDAO drpm;
    @Autowired
    private IDependencyDAO ddep;
    @Autowired
    private AMConverter amc;

    @Transactional
    public Package[] get() {
        HashSet<Package> result = new HashSet<Package>();
        for (EPackage m : this.dpkg.findList()) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new Package[result.size()]);
    }

    @Transactional
    public void save(String name, Package apiObject) {
        this.assertName(name, (INamed)apiObject);
        EPackage m = this.amc.toModel(apiObject);
        if (apiObject.getRpms() != null && !apiObject.getRpms().isEmpty()) {
            HashSet<EPackageVersion> found = new HashSet<EPackageVersion>();
            for (String s : apiObject.getRpms()) {
                EPackageVersion rpm = this.drpm.find(m.getName(), s);
                this.assertModelFound(rpm);
                found.add(rpm);
            }
            m.setRPMs(found);
        } else {
            m.setRPMs(null);
        }
        this.dpkg.save(m);
    }

    @Transactional
    public Package get(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EPackage model = this.findByName(this.dpkg, name);
        return MAConverter.fromModel(model);
    }

    @Transactional
    public void delete(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EPackage model = (EPackage)this.dpkg.findByName(name);
        this.assertModelFound(model);
        this.dpkg.delete(model);
    }

    @Transactional
    public PackageVersion[] getRPMS(String name) {
        RESTAssert.assertNotEmpty((String)name);
        HashSet<PackageVersion> result = new HashSet<PackageVersion>();
        for (EPackageVersion m : this.drpm.find(name)) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new PackageVersion[result.size()]);
    }

    @Transactional
    public void addRPM(String name, String version, PackageVersion rpm) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotNull((Object)rpm);
        RESTAssert.assertEquals((Object)rpm.getVersion(), (Object)version);
        EPackageVersion model = this.amc.toModel(rpm);
        EPackage pkg = this.findByName(this.dpkg, name);
        model.setPkg(pkg);
        HashSet<EDependency> found = new HashSet<EDependency>();
        if (rpm.getDependencies() != null) {
            for (Dependency d : rpm.getDependencies()) {
                EDependency md = this.amc.toModel(d);
                md = (EDependency)this.ddep.save(md);
                found.add(md);
            }
        }
        model.setDependencies(found);
        model = (EPackageVersion)this.drpm.save(model);
        pkg.getRPMs().add(model);
        this.dpkg.save(pkg);
    }

    @Transactional
    public void removeRPM(String name, String version) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)version);
        EPackageVersion rpm = this.drpm.find(name, version);
        this.assertModelFound(rpm);
        this.drpm.delete(rpm);
    }
}

