/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.server.dao.IFindNamed;
import de.taimos.dao.IEntity;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.NotFoundException;

public abstract class ImplHelper {
    protected final <T extends IEntity<?>> void assertModelFound(T model) {
        if (model == null) {
            throw new NotFoundException();
        }
    }

    protected final void assertName(String name, INamed object) {
        RESTAssert.assertNotNull((Object)object);
        RESTAssert.assertEquals((Object)name, (Object)object.getName());
    }

    protected final <T extends IEntity<?>> T findByName(IFindNamed<T> dao, String name) {
        IEntity found = (IEntity)dao.findByName(name);
        this.assertModelFound(found);
        return (T)found;
    }

    protected final <T extends IEntity<?>> List<T> findByName(IFindNamed<T> dao, Set<String> names) {
        ArrayList<IEntity> found = new ArrayList<IEntity>();
        for (String s : names) {
            IEntity t = (IEntity)dao.findByName(s);
            this.assertModelFound(t);
            found.add(t);
        }
        return found;
    }
}

