/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.IIOModule;
import de.cinovo.cloudconductor.api.model.Dependency;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.server.comparators.PackageVersionComparator;
import de.cinovo.cloudconductor.server.dao.IDependencyDAO;
import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class IOModuleImpl
extends ImplHelper
implements IIOModule {
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private IFileDAO dcfg;
    @Autowired
    private ITemplateDAO dtemplate;
    @Autowired
    private IPackageVersionDAO drpm;
    @Autowired
    private IDependencyDAO ddep;
    @Autowired
    private AMConverter amc;

    @Transactional
    public Response importVersions(Set<PackageVersion> rpms) {
        RESTAssert.assertNotEmpty(rpms);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap provided = new HashMap();
        for (PackageVersion rpm : rpms) {
            EPackage mpkg = (EPackage)this.dpkg.findByName(rpm.getName());
            if (mpkg == null) {
                mpkg = new EPackage();
                mpkg.setName(rpm.getName());
                mpkg.setDescription("Auto-generated from repository update on " + sdf.format(Calendar.getInstance().getTime()) + ".");
                mpkg = (EPackage)this.dpkg.save(mpkg);
            }
            if (!provided.containsKey(mpkg.getName())) {
                provided.put(mpkg.getName(), new HashSet());
            }
            EPackageVersion mrpm = this.drpm.find(rpm.getName(), rpm.getVersion());
            ((Set)provided.get(mpkg.getName())).add(rpm.getVersion());
            if (mrpm != null) {
                mrpm.setDeprecated(false);
                this.drpm.save(mrpm);
                continue;
            }
            mrpm = this.amc.toModel(rpm);
            mrpm.setPkg(mpkg);
            HashSet<EDependency> result = new HashSet<EDependency>();
            if (rpm.getDependencies() != null) {
                for (Dependency d : rpm.getDependencies()) {
                    EDependency md = (EDependency)this.ddep.save(this.amc.toModel(d));
                    result.add(md);
                }
            }
            mrpm.setDependencies(result);
            this.drpm.save(mrpm);
        }
        List inDB = this.dpkg.findList();
        List templates = this.dtemplate.findList();
        List cfgs = this.dcfg.findList();
        for (EPackage pkg : inDB) {
            if (provided.containsKey(pkg.getName())) {
                this.handleRPMUsage((Set)provided.get(pkg.getName()), pkg.getRPMs(), templates);
                continue;
            }
            for (EFile cfg : cfgs) {
                if (cfg.getPkg() == null || !cfg.getPkg().equals(pkg)) continue;
                cfg.setPkg(null);
                this.dcfg.save(cfg);
            }
            boolean inUse = this.handleRPMUsage(null, pkg.getRPMs(), templates);
            if (inUse) continue;
            this.dpkg.deleteById(pkg.getId());
        }
        this.autoUpdate(templates);
        return Response.ok().build();
    }

    private boolean handleRPMUsage(Set<String> provided, Set<EPackageVersion> existing, List<ETemplate> templates) {
        boolean deprecated = false;
        if (existing == null) {
            return deprecated;
        }
        for (EPackageVersion dbrpm : existing) {
            if (provided != null && provided.contains(dbrpm.getName())) continue;
            boolean found = false;
            for (ETemplate t : templates) {
                if (!t.getPackageVersions().contains(dbrpm)) continue;
                dbrpm.setDeprecated(true);
                found = true;
                break;
            }
            if (found) {
                this.drpm.save(dbrpm);
                deprecated = true;
                continue;
            }
            this.drpm.deleteById(dbrpm.getId());
        }
        return deprecated;
    }

    private void autoUpdate(List<ETemplate> templates) {
        PackageVersionComparator rpmComp = new PackageVersionComparator();
        for (ETemplate t : templates) {
            if (t.getAutoUpdate() == null || !t.getAutoUpdate().booleanValue()) continue;
            ArrayList<EPackageVersion> list = new ArrayList<EPackageVersion>(t.getPackageVersions());
            for (EPackageVersion rpm : t.getPackageVersions()) {
                ArrayList<EPackageVersion> eprpms = new ArrayList<EPackageVersion>(rpm.getPkg().getRPMs());
                Collections.sort(eprpms, rpmComp);
                EPackageVersion newest = (EPackageVersion)eprpms.get(eprpms.size() - 1);
                if (newest.equals(rpm)) continue;
                list.remove(rpm);
                list.add(newest);
            }
            t.setPackageVersions(list);
            this.dtemplate.save(t);
        }
    }
}

