/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.api.interfaces.IHost;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.IServiceStateDAO;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackageState;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HostImpl
extends ImplHelper
implements IHost {
    @Autowired
    private IHostDAO dhost;
    @Autowired
    private IServiceStateDAO dss;
    @Autowired
    private IServiceDAO dservice;
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private AMConverter amc;

    @Transactional
    public Host[] get() {
        HashSet<Host> result = new HashSet<Host>();
        for (EHost m : this.dhost.findList()) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new Host[result.size()]);
    }

    @Transactional
    public void save(String name, Host apiObject) {
        this.assertName(name, (INamed)apiObject);
        EHost model = this.amc.toModel(apiObject);
        if (apiObject.getServices() != null && !apiObject.getServices().isEmpty()) {
            ArrayList<EServiceState> found = new ArrayList<EServiceState>();
            for (String s : apiObject.getServices()) {
                EServiceState m = this.dss.findByName(s, apiObject.getName());
                if (m == null) continue;
                found.add(m);
            }
            model.setServices(found);
        } else {
            model.setServices(null);
        }
        model.setLastSeen(new DateTime().getMillis());
        this.dhost.save(model);
    }

    @Transactional
    public Host get(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EHost model = this.findByName(this.dhost, name);
        return MAConverter.fromModel(model);
    }

    @Transactional
    public void delete(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EHost model = (EHost)this.dhost.findByName(name);
        this.assertModelFound(model);
        this.dhost.delete(model);
    }

    @Transactional
    public Service[] getServices(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EHost model = (EHost)this.dhost.findByName(name);
        this.assertModelFound(model);
        HashSet<Service> result = new HashSet<Service>();
        for (EServiceState s : model.getServices()) {
            Service svc = MAConverter.fromModel(s);
            result.add(svc);
        }
        return result.toArray(new Service[result.size()]);
    }

    @Transactional
    public void setService(String host, String name, Service service) {
        RESTAssert.assertNotEmpty((String)host);
        this.assertName(name, (INamed)service);
        EHost model = this.findByName(this.dhost, host);
        this.assertModelFound(model);
        EService s = this.amc.toModel(service);
        s.setPackages(this.findByName(this.dpkg, service.getPackages()));
        s = (EService)this.dservice.save(s);
        EServiceState ss = this.dss.findByName(service.getName(), host);
        if (ss == null) {
            ss = new EServiceState();
            ss.setHost(model);
            ss.setService(s);
        }
        ss.setState(service.getState());
        ss = (EServiceState)this.dss.save(ss);
        model.getServices().add(ss);
        this.dhost.save(model);
    }

    @Transactional
    public void removeService(String name, String service) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotNull((Object)service);
        EHost model = this.findByName(this.dhost, name);
        this.assertModelFound(model);
        EServiceState ss = this.dss.findByName(service, name);
        this.assertModelFound(model);
        this.dss.delete(ss);
    }

    @Transactional
    public Boolean inSync(String host) {
        RESTAssert.assertNotNull((Object)host);
        EHost h = this.findByName(this.dhost, host);
        this.assertModelFound(h);
        List<EPackageVersion> trpms = h.getTemplate().getPackageVersions();
        if (h.getPackages() == null || h.getPackages().isEmpty()) {
            return false;
        }
        for (EPackageState hpkg : h.getPackages()) {
            if (trpms.contains(hpkg.getVersion())) continue;
            return false;
        }
        for (EPackageVersion v : trpms) {
            boolean found = false;
            for (EPackageState hpkg : h.getPackages()) {
                if (!v.equals(hpkg.getVersion())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Transactional
    public Response startService(String host, String service) {
        RESTAssert.assertNotNull((Object)host);
        RESTAssert.assertNotNull((Object)service);
        EHost eHost = (EHost)this.dhost.findByName(host);
        for (EServiceState s : eHost.getServices()) {
            if (!s.getService().getName().equals(service)) continue;
            s.setState(ServiceState.STARTING);
            this.dss.save(s);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Transactional
    public Response stopService(String host, String service) {
        RESTAssert.assertNotNull((Object)host);
        RESTAssert.assertNotNull((Object)service);
        EHost eHost = (EHost)this.dhost.findByName(host);
        for (EServiceState s : eHost.getServices()) {
            if (!s.getService().getName().equals(service)) continue;
            s.setState(ServiceState.STOPPING);
            this.dss.save(s);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Transactional
    public Response restartService(String host, String service) {
        RESTAssert.assertNotNull((Object)host);
        RESTAssert.assertNotNull((Object)service);
        EHost eHost = (EHost)this.dhost.findByName(host);
        for (EServiceState s : eHost.getServices()) {
            if (!s.getService().getName().equals(service)) continue;
            s.setState(ServiceState.RESTARTING);
            this.dss.save(s);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

