/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.IFile;
import de.cinovo.cloudconductor.api.model.ConfigFile;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IFileDataDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EFileData;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.rest.helper.AMConverter;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.cinovo.cloudconductor.server.rest.impl.ImplHelper;
import de.taimos.restutils.RESTAssert;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class FileImpl
extends ImplHelper
implements IFile {
    @Autowired
    private IFileDAO dcf;
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private IServiceDAO dservice;
    @Autowired
    private AMConverter amc;
    @Autowired
    private IFileDataDAO dcfd;

    @Transactional
    public ConfigFile[] get() {
        HashSet<ConfigFile> result = new HashSet<ConfigFile>();
        for (EFile m : this.dcf.findList()) {
            result.add(MAConverter.fromModel(m));
        }
        return result.toArray(new ConfigFile[result.size()]);
    }

    @Transactional
    public void save(String name, ConfigFile configFile) {
        this.assertName(name, (INamed)configFile);
        EFile cf = this.amc.toModel(configFile);
        if (configFile.getPkg() != null && !configFile.getPkg().isEmpty()) {
            EPackage pkg = this.findByName(this.dpkg, configFile.getPkg());
            cf.setPkg(pkg);
        } else {
            cf.setPkg(null);
        }
        if (configFile.getDependentServices() != null && !configFile.getDependentServices().isEmpty()) {
            List<EService> services = this.findByName(this.dservice, configFile.getDependentServices());
            cf.setDependentServices(services);
        } else {
            cf.setDependentServices(null);
        }
        this.dcf.save(cf);
    }

    @Transactional
    public ConfigFile get(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile model = this.findByName(this.dcf, name);
        return MAConverter.fromModel(model);
    }

    @Transactional
    public String getData(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile model = this.findByName(this.dcf, name);
        EFileData data = this.dcfd.findDataByFile(model);
        return data.getData();
    }

    @Transactional
    public void saveData(String name, String data) {
        RESTAssert.assertNotEmpty((String)name);
        RESTAssert.assertNotEmpty((String)data);
        EFile model = this.findByName(this.dcf, name);
        try {
            byte[] array = MessageDigest.getInstance("MD5").digest(data.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            model.setChecksum(sb.toString());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            // empty catch block
        }
        model = (EFile)this.dcf.save(model);
        EFileData edata = this.dcfd.findDataByFile(model);
        if (edata == null) {
            edata = new EFileData();
        }
        edata.setData(data);
        edata.setParent(model);
        this.dcfd.save(edata);
    }

    @Transactional
    public void delete(String name) {
        RESTAssert.assertNotEmpty((String)name);
        EFile model = (EFile)this.dcf.findByName(name);
        this.assertModelFound(model);
        this.dcf.delete(model);
    }
}

