/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import de.cinovo.cloudconductor.api.interfaces.IConfigValue;
import de.cinovo.cloudconductor.api.model.KeyValue;
import de.cinovo.cloudconductor.server.dao.IConfigValueDAO;
import de.cinovo.cloudconductor.server.model.EConfigValue;
import de.cinovo.cloudconductor.server.util.AdditionalJavaPropsStore;
import de.taimos.restutils.RESTAssert;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ConfigValueImpl
implements IConfigValue {
    private static final String RESERVED_GLOBAL = "GLOBAL";
    @Autowired
    private IConfigValueDAO dcv;

    @Transactional
    public Map<String, String> get(String template) {
        RESTAssert.assertNotEmpty((String)template);
        HashMap<String, String> result = new HashMap<String, String>();
        for (EConfigValue ecv : this.dcv.findGlobal()) {
            result.put(ecv.getConfigkey(), ecv.getValue());
        }
        if (!template.equalsIgnoreCase(RESERVED_GLOBAL)) {
            for (EConfigValue ecv : this.dcv.findBy(template)) {
                result.put(ecv.getConfigkey(), ecv.getValue());
            }
        }
        return AdditionalJavaPropsStore.merge(result);
    }

    @Transactional
    public Map<String, String> get(String template, String service) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)service);
        Map<String, String> result = this.get(template);
        for (EConfigValue ecv : this.dcv.findGlobal(service)) {
            result.put(ecv.getConfigkey(), ecv.getValue());
        }
        if (!template.equalsIgnoreCase(RESERVED_GLOBAL)) {
            for (EConfigValue ecv : this.dcv.findBy(template, service)) {
                result.put(ecv.getConfigkey(), ecv.getValue());
            }
        }
        return AdditionalJavaPropsStore.merge(result);
    }

    @Transactional
    public String get(String template, String service, String key) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)service);
        RESTAssert.assertNotEmpty((String)key);
        EConfigValue result = null;
        if (!template.equalsIgnoreCase(RESERVED_GLOBAL)) {
            result = this.dcv.findBy(template, service, key);
        }
        if (result == null) {
            result = this.dcv.findKey(template, key);
        }
        if (result == null) {
            result = this.dcv.findGlobal(service, key);
        }
        if (result == null) {
            result = this.dcv.findKey(key);
        }
        if (result == null && AdditionalJavaPropsStore.getValue(key) != null) {
            return AdditionalJavaPropsStore.getValue(key);
        }
        if (result == null) {
            throw new NotFoundException();
        }
        return result.getValue();
    }

    @Transactional
    public void save(String template, String service, KeyValue apiObject) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)service);
        RESTAssert.assertNotEmpty((String)apiObject.getKey());
        EConfigValue ecv = null;
        ecv = !template.equalsIgnoreCase(RESERVED_GLOBAL) ? this.dcv.findBy(template, service, apiObject.getKey()) : this.dcv.findGlobal(service, apiObject.getKey());
        if (ecv == null) {
            ecv = new EConfigValue();
            if (template.equalsIgnoreCase(RESERVED_GLOBAL)) {
                ecv.setTemplate(RESERVED_GLOBAL);
            } else {
                ecv.setTemplate(template);
            }
            ecv.setService(service);
            ecv.setConfigkey(apiObject.getKey());
        }
        ecv.setValue(apiObject.getValue().toString());
        this.dcv.save(ecv);
    }

    @Transactional
    public void save(String template, KeyValue apiObject) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)apiObject.getKey());
        EConfigValue ecv = null;
        ecv = !template.equalsIgnoreCase(RESERVED_GLOBAL) ? this.dcv.findKey(template, apiObject.getKey()) : this.dcv.findKey(apiObject.getKey());
        if (ecv == null) {
            ecv = new EConfigValue();
            if (template.equalsIgnoreCase(RESERVED_GLOBAL)) {
                ecv.setTemplate(RESERVED_GLOBAL);
            } else {
                ecv.setTemplate(template);
            }
            ecv.setService(null);
            ecv.setConfigkey(apiObject.getKey());
        }
        ecv.setValue(apiObject.getValue().toString());
        this.dcv.save(ecv);
    }

    @Transactional
    public void delete(String template, String service, String key) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)service);
        RESTAssert.assertNotEmpty((String)key);
        EConfigValue ecv = null;
        ecv = !template.equalsIgnoreCase(RESERVED_GLOBAL) ? this.dcv.findBy(template, service, key) : this.dcv.findGlobal(service, key);
        if (ecv != null) {
            this.dcv.delete(ecv);
        }
    }

    @Transactional
    public void delete(String template, String key) {
        RESTAssert.assertNotEmpty((String)template);
        RESTAssert.assertNotEmpty((String)key);
        EConfigValue ecv = null;
        ecv = !template.equalsIgnoreCase(RESERVED_GLOBAL) ? this.dcv.findKey(template, key) : this.dcv.findKey(key);
        if (ecv != null) {
            this.dcv.delete(ecv);
        }
    }
}

