/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.impl;

import com.google.common.collect.ArrayListMultimap;
import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.api.interfaces.IAgent;
import de.cinovo.cloudconductor.api.model.ConfigFile;
import de.cinovo.cloudconductor.api.model.Dependency;
import de.cinovo.cloudconductor.api.model.PackageState;
import de.cinovo.cloudconductor.api.model.PackageStateChanges;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.ServiceStates;
import de.cinovo.cloudconductor.api.model.ServiceStatesChanges;
import de.cinovo.cloudconductor.server.comparators.PackageVersionComparator;
import de.cinovo.cloudconductor.server.comparators.VersionStringComparator;
import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageStateDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDefaultStateDAO;
import de.cinovo.cloudconductor.server.dao.IServiceStateDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageState;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceDefaultState;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.model.ETemplate;
import de.cinovo.cloudconductor.server.model.enums.PackageCommand;
import de.cinovo.cloudconductor.server.rest.helper.MAConverter;
import de.taimos.restutils.RESTAssert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AgentImpl
implements IAgent {
    private static final int MAX_TIMEOUT_HOST = 30;
    private static final int MAX_UPDATE_THRESHOLD = 15;
    @Autowired
    private IHostDAO dhost;
    @Autowired
    private ITemplateDAO dtemplate;
    @Autowired
    private IServiceDAO dsvc;
    @Autowired
    private IServiceStateDAO dsvcstate;
    @Autowired
    private IPackageVersionDAO drpm;
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private IPackageStateDAO dpkgstate;
    @Autowired
    private IServiceDefaultStateDAO ddefss;

    @Transactional
    public Set<String> getAliveAgents() {
        List hosts = this.dhost.findList();
        DateTime now = new DateTime();
        HashSet<String> result = new HashSet<String>();
        for (EHost host : hosts) {
            DateTime dt = new DateTime((Object)host.getLastSeen());
            int diff = Minutes.minutesBetween((ReadableInstant)dt, (ReadableInstant)now).getMinutes();
            if (diff >= 30) continue;
            result.add(host.getName());
        }
        return result;
    }

    @Transactional
    public PackageStateChanges notifyPackageState(String tname, String hname, PackageState rpmState) {
        RESTAssert.assertNotEmpty((String)hname);
        RESTAssert.assertNotEmpty((String)tname);
        EHost host = (EHost)this.dhost.findByName(hname);
        ETemplate template = (ETemplate)this.dtemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        if (host == null) {
            host = this.createNewHost(hname, template);
        }
        DateTime now = new DateTime();
        host.setLastSeen(now.getMillis());
        List packages = this.dpkg.findList();
        HashSet<EPackageState> leftPackages = new HashSet<EPackageState>(host.getPackages());
        for (PackageVersion irpm : rpmState.getInstalledRpms()) {
            EPackageState state;
            EPackage pkg = null;
            for (EPackage p : packages) {
                if (!p.getName().equals(irpm.getName())) continue;
                pkg = p;
                break;
            }
            if (pkg == null || (state = this.updateExistingState(host, irpm, leftPackages)) != null) continue;
            state = this.createMissingState(host, irpm, pkg);
            host.getPackages().add(state);
        }
        for (EPackageState pkg : leftPackages) {
            if (!host.getPackages().contains(pkg)) continue;
            host.getPackages().remove(pkg);
            this.dpkgstate.delete(pkg);
        }
        if (this.sendPackageChanges(template, host = (EHost)this.dhost.save(host))) {
            HashSet<EPackageVersion> actual = new HashSet<EPackageVersion>();
            for (EPackageState state : host.getPackages()) {
                actual.add(state.getVersion());
            }
            ArrayListMultimap<PackageCommand, PackageVersion> diff = this.computePackageDiff(template.getPackageVersions(), actual);
            if (!(diff.get((Object)PackageCommand.INSTALL).isEmpty() && diff.get((Object)PackageCommand.UPDATE).isEmpty() && diff.get((Object)PackageCommand.ERASE).isEmpty())) {
                host.setStartedUpdate(DateTime.now().getMillis());
            }
            return new PackageStateChanges(diff.get((Object)PackageCommand.INSTALL), diff.get((Object)PackageCommand.UPDATE), diff.get((Object)PackageCommand.ERASE));
        }
        return new PackageStateChanges(new ArrayList(), new ArrayList(), new ArrayList());
    }

    private EHost createNewHost(String hname, ETemplate template) {
        EHost host = new EHost();
        host.setName(hname);
        host.setTemplate(template);
        host = (EHost)this.dhost.save(host);
        return host;
    }

    private boolean sendPackageChanges(ETemplate template, EHost host) {
        DateTime now = DateTime.now();
        int maxHostsOnUpdate = template.getHosts().size() / 2;
        int hostsOnUpdate = 0;
        if (template.getSmoothUpdate() == null || !template.getSmoothUpdate().booleanValue() || maxHostsOnUpdate < 1) {
            return true;
        }
        if (host.getStartedUpdate() != null) {
            return true;
        }
        for (EHost h : template.getHosts()) {
            int timeElapsed;
            if (h.getStartedUpdate() == null || (timeElapsed = Minutes.minutesBetween((ReadableInstant)new DateTime((Object)h.getStartedUpdate()), (ReadableInstant)now).getMinutes()) > 15) continue;
            ++hostsOnUpdate;
        }
        return maxHostsOnUpdate > hostsOnUpdate;
    }

    private EPackageState createMissingState(EHost host, PackageVersion irpm, EPackage pkg) {
        EPackageVersion rpm = this.drpm.find(irpm.getName(), irpm.getVersion());
        if (rpm == null) {
            rpm = new EPackageVersion();
            rpm.setPkg(pkg);
            rpm.setVersion(irpm.getVersion());
            rpm.setDeprecated(true);
            rpm = (EPackageVersion)this.drpm.save(rpm);
        }
        EPackageState state = new EPackageState();
        state.setHost(host);
        state.setVersion(rpm);
        state = (EPackageState)this.dpkgstate.save(state);
        return state;
    }

    private EPackageState updateExistingState(EHost host, PackageVersion irpm, HashSet<EPackageState> leftPackages) {
        VersionStringComparator vsc = new VersionStringComparator();
        for (EPackageState state : host.getPackages()) {
            if (!state.getVersion().getPkg().getName().equals(irpm.getName())) continue;
            int comp = vsc.compare(state.getVersion().getVersion(), irpm.getVersion());
            if (comp == 0) break;
            EPackageVersion rpm = this.drpm.find(irpm.getName(), irpm.getVersion());
            if (rpm == null) {
                rpm = new EPackageVersion();
                rpm.setPkg(state.getVersion().getPkg());
                rpm.setVersion(irpm.getVersion());
                rpm.setDeprecated(true);
                rpm = (EPackageVersion)this.drpm.save(rpm);
            }
            leftPackages.remove(state);
            state.setVersion(rpm);
            return (EPackageState)this.dpkgstate.save(state);
        }
        return null;
    }

    private boolean asserHostServices(ETemplate template, EHost host) {
        List services = this.dsvc.findList();
        HashSet<EService> templateServices = new HashSet<EService>();
        for (EService s : services) {
            for (EPackageVersion p : template.getPackageVersions()) {
                if (!s.getPackages().contains(p.getPkg())) continue;
                templateServices.add(s);
            }
        }
        HashSet missingServices = new HashSet(templateServices);
        for (EServiceState state : host.getServices()) {
            for (EService service : templateServices) {
                if (!service.getName().equals(state.getService().getName())) continue;
                missingServices.remove(service);
            }
        }
        boolean changes = false;
        for (EService service : missingServices) {
            EServiceState state = new EServiceState();
            state.setService(service);
            state.setHost(host);
            EServiceDefaultState dss = this.ddefss.findByName(service.getName(), template.getName());
            if (dss == null || dss.getState().equals((Object)ServiceState.STOPPED)) {
                state.setState(ServiceState.STOPPING);
            } else {
                state.setState(dss.getState());
            }
            this.dsvcstate.save(state);
            changes = true;
        }
        return changes;
    }

    @Transactional
    public ServiceStatesChanges notifyServiceState(String tname, String hname, ServiceStates serviceState) {
        RESTAssert.assertNotEmpty((String)hname);
        RESTAssert.assertNotEmpty((String)tname);
        EHost host = (EHost)this.dhost.findByName(hname);
        ETemplate template = (ETemplate)this.dtemplate.findByName(tname);
        RESTAssert.assertNotNull((Object)template);
        if (host == null) {
            host = this.createNewHost(hname, template);
        }
        if (this.asserHostServices(template, host)) {
            host = (EHost)this.dhost.findByName(hname);
        }
        HashSet<String> toStop = new HashSet<String>();
        HashSet<String> toStart = new HashSet<String>();
        HashSet<String> toRestart = new HashSet<String>();
        HashSet<EServiceState> stateList = new HashSet<EServiceState>(host.getServices());
        block0: for (String sname : serviceState.getRunningServices()) {
            for (EServiceState state : host.getServices()) {
                if (!state.getService().getName().equals(sname)) continue;
                stateList.remove(state);
                if (state.getState().equals((Object)ServiceState.STARTING)) {
                    state.setState(ServiceState.RUNNING);
                    this.dsvcstate.save(state);
                    continue block0;
                }
                if (state.getState().equals((Object)ServiceState.STOPPING)) {
                    toStop.add(state.getService().getInitScript());
                    continue block0;
                }
                if (state.getState().equals((Object)ServiceState.STOPPED)) {
                    toStop.add(state.getService().getInitScript());
                    state.setState(ServiceState.STOPPING);
                    this.dsvcstate.save(state);
                    continue block0;
                }
                if (state.getState().equals((Object)ServiceState.RESTARTING)) {
                    toRestart.add(state.getService().getInitScript());
                    state.setState(ServiceState.RESTARTED);
                    this.dsvcstate.save(state);
                    continue block0;
                }
                if (!state.getState().equals((Object)ServiceState.RESTARTED)) continue block0;
                state.setState(ServiceState.RUNNING);
                this.dsvcstate.save(state);
                continue block0;
            }
        }
        for (EServiceState state : stateList) {
            if (state.getState().equals((Object)ServiceState.STARTING)) {
                toStart.add(state.getService().getInitScript());
                this.dsvcstate.save(state);
                continue;
            }
            if (state.getState().equals((Object)ServiceState.STOPPING)) {
                state.setState(ServiceState.STOPPED);
                this.dsvcstate.save(state);
                continue;
            }
            if (!state.getState().equals((Object)ServiceState.RUNNING)) continue;
            toStart.add(state.getService().getInitScript());
            state.setState(ServiceState.STARTING);
            this.dsvcstate.save(state);
        }
        HashSet<ConfigFile> configFiles = new HashSet<ConfigFile>();
        for (EFile file : template.getConfigFiles()) {
            configFiles.add(MAConverter.fromModel(file));
        }
        if (toStart.isEmpty() && toStop.isEmpty() && toRestart.isEmpty() && host.getStartedUpdate() != null) {
            host.setStartedUpdate(null);
            this.dhost.save(host);
        }
        return new ServiceStatesChanges(toStart, toStop, toRestart, configFiles);
    }

    private ArrayListMultimap<PackageCommand, PackageVersion> computePackageDiff(Collection<EPackageVersion> nominal, Collection<EPackageVersion> actual) {
        TreeSet<EPackageVersion> toInstall = new TreeSet<EPackageVersion>(new PackageVersionComparator());
        toInstall.addAll(nominal);
        toInstall.removeAll(actual);
        TreeSet<EPackageVersion> toErase = new TreeSet<EPackageVersion>(new PackageVersionComparator());
        toErase.addAll(actual);
        toErase.removeAll(nominal);
        TreeSet<EPackageVersion> toUpdate = new TreeSet<EPackageVersion>(new PackageVersionComparator());
        for (EPackageVersion i : toInstall) {
            EPackageVersion e = toErase.lower(i);
            if (e == null || !e.getPkg().getName().equals(i.getPkg().getName())) continue;
            toErase.remove(e);
            toUpdate.add(i);
        }
        toInstall.removeAll(toUpdate);
        ArrayListMultimap<PackageCommand, PackageVersion> result = ArrayListMultimap.create();
        result = this.fillPackageDiff(result, PackageCommand.INSTALL, toInstall);
        result = this.fillPackageDiff(result, PackageCommand.UPDATE, toUpdate);
        result = this.fillPackageDiff(result, PackageCommand.ERASE, toErase);
        return result;
    }

    private ArrayListMultimap<PackageCommand, PackageVersion> fillPackageDiff(ArrayListMultimap<PackageCommand, PackageVersion> map, PackageCommand command, Collection<EPackageVersion> packageVersions) {
        for (EPackageVersion pv : packageVersions) {
            String rpmName = pv.getPkg().getName();
            HashSet<Dependency> dep = new HashSet<Dependency>();
            for (EDependency edep : pv.getDependencies()) {
                dep.add(MAConverter.fromModel(edep));
            }
            map.put((Object)command, (Object)new PackageVersion(rpmName, pv.getVersion(), dep));
        }
        return map;
    }
}

