/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.helper;

import de.cinovo.cloudconductor.api.ServiceState;
import de.cinovo.cloudconductor.api.model.ConfigFile;
import de.cinovo.cloudconductor.api.model.Dependency;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.Template;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ESSHKey;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.EServiceState;
import de.cinovo.cloudconductor.server.model.ETemplate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MAConverter {
    private MAConverter() {
    }

    public static <K extends INamed> Set<String> fromModel(Collection<K> models) {
        HashSet<String> result = new HashSet<String>();
        for (INamed model : models) {
            if (model.getName().isEmpty()) continue;
            result.add(model.getName());
        }
        return result;
    }

    public static Template fromModel(ETemplate model) {
        HashMap<String, String> rpms = new HashMap<String, String>();
        for (EPackageVersion rpm : model.getPackageVersions()) {
            rpms.put(rpm.getPkg().getName(), rpm.getVersion());
        }
        return new Template(model.getName(), model.getDescription(), model.getYumPath(), rpms, MAConverter.fromModel(model.getHosts()), MAConverter.fromModel(model.getSshkeys()), MAConverter.fromModel(model.getConfigFiles()));
    }

    public static SSHKey fromModel(ESSHKey model) {
        return new SSHKey(model.getKeycontent(), model.getOwner());
    }

    public static Service fromModel(EService model) {
        return new Service(model.getName(), model.getDescription(), model.getInitScript(), ServiceState.UNKNOWN, MAConverter.fromModel(model.getPackages()));
    }

    public static Service fromModel(EServiceState model) {
        return new Service(model.getService().getName(), model.getService().getDescription(), model.getService().getInitScript(), model.getState(), MAConverter.fromModel(model.getService().getPackages()));
    }

    public static ConfigFile fromModel(EFile model) {
        Set<String> services = MAConverter.fromModel(model.getDependentServices());
        return new ConfigFile(model.getName(), model.getPkg() == null ? null : model.getPkg().getName(), model.getTargetPath(), model.getOwner(), model.getGroup(), model.getFileMode(), model.isTemplate(), model.isReloadable(), model.getChecksum(), services);
    }

    public static Dependency fromModel(EDependency model) {
        return new Dependency(model.getName(), model.getVersion(), model.getOperator(), model.getType().toString());
    }

    public static Host fromModel(EHost model) {
        HashSet<String> services = new HashSet<String>();
        for (EServiceState ss : model.getServices()) {
            if (model.getName().isEmpty()) continue;
            services.add(ss.getService().getName());
        }
        return new Host(model.getName(), model.getDescription(), model.getTemplate().getName(), services);
    }

    public static Package fromModel(EPackage model) {
        Set<String> rpms = MAConverter.fromModel(model.getRPMs());
        return new Package(model.getName(), model.getDescription(), rpms);
    }

    public static PackageVersion fromModel(EPackageVersion model) {
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (EDependency md : model.getDependencies()) {
            deps.add(MAConverter.fromModel(md));
        }
        return new PackageVersion(model.getPkg().getName(), model.getVersion(), deps);
    }
}

