/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.rest.helper;

import de.cinovo.cloudconductor.api.model.ConfigFile;
import de.cinovo.cloudconductor.api.model.Dependency;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.Template;
import de.cinovo.cloudconductor.server.dao.IDependencyDAO;
import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.IHostDAO;
import de.cinovo.cloudconductor.server.dao.IPackageDAO;
import de.cinovo.cloudconductor.server.dao.IPackageServerDAO;
import de.cinovo.cloudconductor.server.dao.IPackageVersionDAO;
import de.cinovo.cloudconductor.server.dao.ISSHKeyDAO;
import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.ITemplateDAO;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EPackageServer;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ESSHKey;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.ETemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AMConverter {
    @Autowired
    private ISSHKeyDAO dssh;
    @Autowired
    private IFileDAO dcf;
    @Autowired
    private IHostDAO dhost;
    @Autowired
    private IPackageDAO dpkg;
    @Autowired
    private IPackageVersionDAO drpm;
    @Autowired
    private IServiceDAO dservice;
    @Autowired
    private ITemplateDAO dtemplate;
    @Autowired
    private IDependencyDAO ddependendy;
    @Autowired
    private IPackageServerDAO packageServer;

    public ETemplate toModel(Template api) {
        ETemplate model = new ETemplate();
        model.setName(api.getName());
        model.setDescription(api.getDescription());
        for (EPackageServer serv : this.packageServer.findList()) {
            if (!serv.getPath().equals(api.getYum()) && !serv.getPath().equals("http://" + api.getYum())) continue;
            model.setYum(serv);
            break;
        }
        return model;
    }

    public EFile toModel(ConfigFile api) {
        EFile model = (EFile)this.dcf.findByName(api.getName());
        if (model == null) {
            model = new EFile();
            model.setName(api.getName());
        }
        model.setFileMode(api.getFileMode());
        model.setChecksum(api.getChecksum());
        model.setGroup(api.getGroup());
        model.setOwner(api.getOwner());
        model.setReloadable(api.isReloadable());
        model.setTemplate(api.isTemplate());
        model.setTargetPath(api.getTargetPath());
        model.setPkg((EPackage)this.dpkg.findByName(api.getPkg()));
        return model;
    }

    public EDependency toModel(Dependency api) {
        EDependency model = this.ddependendy.find(api);
        if (model == null) {
            model = new EDependency();
            model.setName(api.getName());
            model.setOperator(api.getOperator());
            model.setType(api.getType());
            model.setVersion(api.getVersion());
        }
        return model;
    }

    public EHost toModel(Host api) {
        EHost model = (EHost)this.dhost.findByName(api.getName());
        if (model == null) {
            model = new EHost();
            model.setName(api.getName());
        }
        model.setDescription(api.getDescription());
        ETemplate template = (ETemplate)this.dtemplate.findByName(api.getTemplate());
        if (template != null) {
            model.setTemplate(template);
        }
        return model;
    }

    public EPackage toModel(Package api) {
        EPackage model = (EPackage)this.dpkg.findByName(api.getName());
        if (model == null) {
            model = new EPackage();
            model.setName(api.getName());
        }
        model.setDescription(api.getDescription());
        return model;
    }

    public EPackageVersion toModel(PackageVersion api) {
        EPackageVersion model = this.drpm.find(api.getName(), api.getVersion());
        if (model == null) {
            model = new EPackageVersion();
            model.setVersion(api.getVersion());
        }
        return model;
    }

    public EService toModel(Service api) {
        EService model = (EService)this.dservice.findByName(api.getName());
        if (model == null) {
            model = new EService();
            model.setName(api.getName());
        }
        model.setDescription(api.getDescription());
        model.setInitScript(api.getInitScript());
        return model;
    }

    public ESSHKey toModel(SSHKey api) {
        ESSHKey model = this.dssh.findByOwner(api.getOwner());
        if (model == null) {
            model = new ESSHKey();
            model.setOwner(api.getOwner());
        }
        model.setKeycontent(api.getKey());
        return model;
    }
}

