/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.model;

import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EHost;
import de.cinovo.cloudconductor.server.model.EPackageServer;
import de.cinovo.cloudconductor.server.model.EPackageVersion;
import de.cinovo.cloudconductor.server.model.ESSHKey;
import de.taimos.dao.IEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="template", schema="cloudconductor")
public class ETemplate
implements IEntity<Long>,
INamed {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private List<EPackageVersion> packageVersions;
    private List<EHost> hosts;
    private List<ESSHKey> sshkeys;
    private List<EFile> configFiles;
    private EPackageServer yum;
    private Boolean autoUpdate;
    private Boolean smoothUpdate;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinTable(name="mappingfiletemplate", schema="cloudconductor", joinColumns={@JoinColumn(name="templateid")}, inverseJoinColumns={@JoinColumn(name="fileid")})
    public List<EFile> getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(List<EFile> configFiles) {
        this.configFiles = configFiles;
    }

    @OneToMany(mappedBy="template", fetch=FetchType.LAZY)
    public List<EHost> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<EHost> hosts) {
        this.hosts = hosts;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinTable(name="mappingrpmtemplate", schema="cloudconductor", joinColumns={@JoinColumn(name="templateid")}, inverseJoinColumns={@JoinColumn(name="rpmid")})
    public List<EPackageVersion> getPackageVersions() {
        return this.packageVersions;
    }

    public void setPackageVersions(List<EPackageVersion> rpms) {
        this.packageVersions = rpms;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinTable(name="mappingtemplatesshkey", schema="cloudconductor", joinColumns={@JoinColumn(name="templateid")}, inverseJoinColumns={@JoinColumn(name="sshkeyid")})
    public List<ESSHKey> getSshkeys() {
        return this.sshkeys;
    }

    public void setSshkeys(List<ESSHKey> sshkeys) {
        this.sshkeys = sshkeys;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="yum")
    public EPackageServer getYum() {
        return this.yum;
    }

    @Transient
    public String getYumPath() {
        return this.yum.getPath();
    }

    public void setYum(EPackageServer yum) {
        this.yum = yum;
    }

    public Boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public Boolean getSmoothUpdate() {
        return this.smoothUpdate;
    }

    public void setSmoothUpdate(Boolean smoothUpdate) {
        this.smoothUpdate = smoothUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ETemplate)) {
            return false;
        }
        ETemplate other = (ETemplate)obj;
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }
}

