/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.model;

import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.server.model.EDependency;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.taimos.dao.IEntity;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="packageversion", schema="cloudconductor")
public class EPackageVersion
implements IEntity<Long>,
INamed {
    private static final long serialVersionUID = 1L;
    private Long id;
    private EPackage pkg;
    private String version;
    private Set<EDependency> dependencies = new HashSet<EDependency>();
    private Boolean deprecated;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="packageid")
    public EPackage getPkg() {
        return this.pkg;
    }

    public void setPkg(EPackage pkg) {
        this.pkg = pkg;
    }

    @Column(nullable=false)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.EAGER)
    @JoinTable(name="mappingrpmdep", schema="cloudconductor", joinColumns={@JoinColumn(name="rpmid")}, inverseJoinColumns={@JoinColumn(name="dependencyid")})
    public Set<EDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<EDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Transient
    public String getName() {
        return this.getVersion();
    }

    public void setName(String name) {
        this.setVersion(name);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EPackageVersion)) {
            return false;
        }
        EPackageVersion other = (EPackageVersion)obj;
        if (this.getVersion() == null) {
            return false;
        }
        if (!this.getVersion().equals(other.getVersion())) {
            return false;
        }
        return this.getPkg().equals(other.getPkg());
    }

    public int hashCode() {
        int val = this.getVersion() == null ? 0 : this.getVersion().hashCode();
        int parent = this.getPkg() == null ? 0 : this.getPkg().hashCode();
        return val * parent;
    }
}

