/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.model;

import de.cinovo.cloudconductor.api.model.INamed;
import de.cinovo.cloudconductor.server.model.EFileTag;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.IVersionized;
import de.taimos.dao.IEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="file", schema="cloudconductor")
public class EFile
implements IVersionized<Long>,
INamed {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private EPackage pkg;
    private String targetPath;
    private String owner;
    private String group;
    private String fileMode;
    private boolean isTemplate;
    private boolean isReloadable;
    private String checksum;
    private List<EService> dependentServices;
    private List<EFileTag> tags;
    private Long version;
    private boolean deleted = false;
    private Long origId;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="packageid")
    public EPackage getPkg() {
        return this.pkg;
    }

    public void setPkg(EPackage pkg) {
        this.pkg = pkg;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="filegroup", nullable=false)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public boolean isReloadable() {
        return this.isReloadable;
    }

    public void setReloadable(boolean isReloadable) {
        this.isReloadable = isReloadable;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinTable(name="mappingfileservice", schema="cloudconductor", joinColumns={@JoinColumn(name="fileid")}, inverseJoinColumns={@JoinColumn(name="serviceid")})
    public List<EService> getDependentServices() {
        return this.dependentServices;
    }

    public void setDependentServices(List<EService> dependentServices) {
        this.dependentServices = dependentServices;
    }

    @Column(nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToMany(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinTable(name="taggedfiles", schema="cloudconductor", joinColumns={@JoinColumn(name="fileid")}, inverseJoinColumns={@JoinColumn(name="tagid")})
    public List<EFileTag> getTags() {
        return this.tags;
    }

    public void setTags(List<EFileTag> tags) {
        this.tags = tags;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public void setOrigId(Long id) {
        this.origId = id;
    }

    @Override
    public Long getOrigId() {
        return this.origId;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EFile)) {
            return false;
        }
        EFile other = (EFile)obj;
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    @Override
    public IEntity<Long> cloneNew() {
        EFile r = new EFile();
        r.setChecksum(this.checksum);
        r.setDeleted(this.deleted);
        r.setDependentServices(this.dependentServices);
        r.setFileMode(this.fileMode);
        r.setGroup(this.group);
        r.setName(this.name);
        r.setOrigId(this.origId);
        r.setOwner(this.owner);
        r.setPkg(this.pkg);
        r.setReloadable(this.isReloadable);
        r.setTags(this.tags);
        r.setTargetPath(this.targetPath);
        r.setTemplate(this.isTemplate);
        r.setVersion(this.version);
        return r;
    }
}

