/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.dao.hibernate;

import de.cinovo.cloudconductor.server.dao.IServiceDAO;
import de.cinovo.cloudconductor.server.dao.hibernate.AAuditedEntityHib;
import de.cinovo.cloudconductor.server.model.EPackage;
import de.cinovo.cloudconductor.server.model.EService;
import de.cinovo.cloudconductor.server.model.enums.AuditCategory;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;

@Repository(value="ServiceDAOHib")
public class ServiceDAOHib
extends AAuditedEntityHib<EService, Long>
implements IServiceDAO {
    public Class<EService> getEntityClass() {
        return EService.class;
    }

    @Override
    public EService findByName(String name) {
        return (EService)this.findByQuery("FROM EService s WHERE s.name = ?1", new Object[]{name});
    }

    @Override
    public List<EService> findByName(Set<String> names) {
        StringBuilder find = new StringBuilder();
        find.append("(");
        for (String n : names) {
            find.append("'" + n + "'");
        }
        find.append(")");
        return this.findListByQuery("FROM EService s WHERE s.name IN ?1", new Object[]{find});
    }

    @Override
    public List<EService> findByPackage(EPackage pkg) {
        return this.findListByQuery("FROM EService s WHERE ?1 in elements(s.packages)", new Object[]{pkg});
    }

    @Override
    public Long count() {
        return (Long)this.entityManager.createQuery("SELECT COUNT(*) FROM EService").getSingleResult();
    }

    @Override
    protected AuditCategory getAuditCategory() {
        return AuditCategory.SERVICE;
    }
}

