/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.dao.hibernate;

import de.cinovo.cloudconductor.server.dao.IFileDAO;
import de.cinovo.cloudconductor.server.dao.hibernate.AVersionedEntityHib;
import de.cinovo.cloudconductor.server.model.EFile;
import de.cinovo.cloudconductor.server.model.EFileTag;
import de.cinovo.cloudconductor.server.model.enums.AuditCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="FileDAOHib")
public class FileDAOHib
extends AVersionedEntityHib<EFile>
implements IFileDAO {
    public Class<EFile> getEntityClass() {
        return EFile.class;
    }

    @Override
    public EFile findByName(String name) {
        return (EFile)this.findVersionedByQuery("FROM EFile c WHERE c.name = ?1", "c", name);
    }

    @Override
    public Long count() {
        return (Long)this.entityManager.createQuery(this.getVersionizedQuerry("SELECT COUNT(*) FROM EFile", "f")).getSingleResult();
    }

    @Override
    public List<EFile> findByTag(String ... tagnames) {
        String query = "FROM EFile f WHERE f.tags.name IN ?1";
        return this.findVersionedListByQuery(query, "f", Arrays.asList(tagnames));
    }

    @Override
    public List<EFile> findByTag(EFileTag ... tags) {
        List findList = this.findList();
        ArrayList<EFile> result = new ArrayList<EFile>();
        List<EFileTag> taged = Arrays.asList(tags);
        for (EFile f : findList) {
            if (Collections.disjoint(f.getTags(), taged)) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    protected AuditCategory getAuditCategory() {
        return AuditCategory.FILE;
    }
}

