/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.dao.hibernate;

import de.cinovo.cloudconductor.server.dao.hibernate.AAuditedEntityHib;
import de.cinovo.cloudconductor.server.model.IVersionized;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import javax.persistence.TypedQuery;
import org.springframework.transaction.annotation.Transactional;

public abstract class AVersionedEntityHib<E extends IVersionized<Long>>
extends AAuditedEntityHib<E, Long> {
    @Override
    @Transactional
    public E save(E element, String auditMessage) {
        if (element.getId() == null || (Long)element.getId() < 0L) {
            return this.saveNewElement(element);
        }
        if (auditMessage == null) {
            return (E)((IVersionized)super.save(this.createNewRevision(element), this.getChangeEntry(element)));
        }
        return (E)((IVersionized)super.save(this.createNewRevision(element), auditMessage));
    }

    @Override
    @Transactional
    public E save(E element) {
        this.entityManager.detach(element);
        return this.save(element, null);
    }

    @Transactional
    private E createNewRevision(E element) {
        IVersionized r = (IVersionized)element.cloneNew();
        if (r.getVersion() == null || (Long)r.getVersion() < 0L) {
            r.setVersion(0L);
        } else {
            r.setVersion((Long)element.getVersion() + 1L);
        }
        r.setDeleted(false);
        r.setOrigId(element.getOrigId());
        return (E)r;
    }

    @Transactional
    private E saveNewElement(E element) {
        element.setVersion(0L);
        element.setDeleted(false);
        IVersionized ele = (IVersionized)super.save(element);
        ele.setOrigId(ele.getId());
        return (E)((IVersionized)this.entityManager.merge((Object)ele));
    }

    @Override
    @Transactional
    public void delete(E element, String auditMessage) {
        element.setDeleted(true);
        super.save(element, auditMessage);
    }

    @Override
    @Transactional
    public void delete(E element) {
        element.setDeleted(true);
        super.save(element);
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        IVersionized element = (IVersionized)this.findById(id);
        if (element == null) {
            throw new EntityNotFoundException();
        }
        this.delete((E)element);
    }

    @Transactional
    protected List<E> findVersionedList() {
        TypedQuery query = this.entityManager.createQuery(this.getFindAllListQuery(), this.getEntityClass());
        return query.getResultList();
    }

    @Transactional
    protected final E findVersionedByQuery(String query, String as, Object ... params) {
        return (E)((IVersionized)super.findByQuery(this.getVersionizedQuerry(query, as), params));
    }

    @Transactional
    protected final List<E> findVersionedListByQuery(String query, String as, Object ... params) {
        return super.findListByQuery(this.getVersionizedQuerry(query, as), params);
    }

    @Transactional
    protected String getVersionizedQuerry(String query, String as) {
        String maxVersion = "SELECT MAX(second.version) FROM  " + this.getEntityClass().getSimpleName() + " as second WHERE second.origId = " + as + ".origId";
        StringBuilder newQuery = new StringBuilder();
        newQuery.append(query);
        if (query.contains("WHERE")) {
            newQuery.append(" AND ");
        } else {
            newQuery.append(" as " + as + " WHERE ");
        }
        newQuery.append(as);
        newQuery.append(".deleted=false AND ");
        newQuery.append(as);
        newQuery.append(".version=(");
        newQuery.append(maxVersion);
        newQuery.append(")");
        return newQuery.toString();
    }

    @Transactional
    protected String getFindListQuery() {
        return this.getVersionizedQuerry("FROM " + this.getEntityClass().getSimpleName(), "first");
    }

    @Transactional
    protected String getFindAllListQuery() {
        return "FROM " + this.getEntityClass().getSimpleName();
    }
}

