/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server.comparators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionStringComparator
implements Comparator<String> {
    @Override
    public int compare(String version1, String version2) {
        String[] stringArray;
        String[] stringArray2;
        String[] parts1 = version1.split("-", 2);
        if (parts1.length == 2 && !parts1[1].isEmpty()) {
            stringArray2 = parts1;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = parts1[0];
            stringArray2 = stringArray3;
            stringArray3[1] = "1";
        }
        parts1 = stringArray2;
        String[] parts2 = version2.split("-", 2);
        if (parts2.length == 2 && !parts2[1].isEmpty()) {
            stringArray = parts2;
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = parts2[0];
            stringArray = stringArray4;
            stringArray4[1] = "1";
        }
        parts2 = stringArray;
        if (version1.isEmpty() != version2.isEmpty()) {
            return Boolean.compare(!version1.isEmpty(), !version2.isEmpty());
        }
        String[] v1 = parts1[0].split("\\.");
        String[] v2 = parts2[0].split("\\.");
        for (int i = 0; i < Math.max(v1.length, v2.length); ++i) {
            String x2;
            String x1 = i < v1.length ? v1[i] : "0";
            int c = this.compareVersionParts(x1, x2 = i < v2.length ? v2[i] : "0");
            if (c == 0) continue;
            return c;
        }
        return this.compareVersionParts(parts1[1], parts2[1]);
    }

    private int compareVersionParts(String input1, String input2) {
        String[] r1 = this.splitAtDigitBoundaries(input1);
        String[] r2 = this.splitAtDigitBoundaries(input2);
        for (int i = 0; i < Math.max(r1.length, r2.length); ++i) {
            String s2;
            String s1 = i < r1.length ? r1[i] : "";
            String string = s2 = i < r2.length ? r2[i] : "";
            if (s1.isEmpty() != s2.isEmpty()) {
                return Boolean.compare(!s1.isEmpty(), !s2.isEmpty());
            }
            boolean b1 = this.beginsWithDigit(s1);
            boolean b2 = this.beginsWithDigit(s2);
            if (b1 && b2) {
                String ss1 = this.stripLeadingZeros(s1);
                String ss2 = this.stripLeadingZeros(s2);
                int c = Integer.compare(ss1.length(), ss2.length());
                if (c != 0) {
                    return c;
                }
                c = ss1.compareTo(ss2);
                if (c != 0) {
                    return c;
                }
                c = Integer.compare(s1.length(), s2.length());
                if (c == 0) continue;
                return c;
            }
            if (!b1 && !b2) {
                int c = s1.compareTo(s2);
                if (c == 0) continue;
                return c;
            }
            return Boolean.compare(b1, b2);
        }
        return 0;
    }

    private String[] splitAtDigitBoundaries(String str) {
        Matcher matcher = Pattern.compile("\\d+").matcher(str);
        ArrayList<String> parts = new ArrayList<String>();
        int pos = 0;
        while (matcher.find()) {
            if (matcher.start() > 0) {
                parts.add(str.substring(pos, matcher.start()));
            }
            parts.add(matcher.group());
            pos = matcher.end();
        }
        if (pos < str.length()) {
            parts.add(str.substring(pos, str.length()));
        }
        return parts.toArray(new String[parts.size()]);
    }

    private boolean beginsWithDigit(String str) {
        return str.substring(0, 1).matches("\\d");
    }

    private String stripLeadingZeros(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == '0'; ++i) {
        }
        return str.substring(i, str.length());
    }
}

