/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.server;

import de.cinovo.cloudconductor.server.util.AdditionalJavaPropsStore;
import de.cinovo.cloudconductor.server.util.CleanUpTask;
import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.LifecyclePhase;
import de.taimos.daemon.properties.FilePropertyProvider;
import de.taimos.daemon.properties.IPropertyProvider;
import de.taimos.springcxfdaemon.SpringDaemonAdapter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.velocity.app.Velocity;

public class ServerStarter
extends SpringDaemonAdapter {
    private static final String CLOUDCONDUCTOR_PROPERTIES = "cloudconductor.properties";
    private static final String EXCEPTION_IN_PHASE = "Exception in phase %s.";
    public static final String DAEMON_NAME = "cloudconductor";
    private static final Logger log = Logger.getLogger(ServerStarter.class);
    public static final ScheduledExecutorService ses = Executors.newScheduledThreadPool(10);
    private static final String CLOUDCONDUCTOR_URL = "cloudconductor.url";
    private static final String HAZELCAST_MEMBERS = "hazelcast.members";
    private static final int CLEANUP_TIMER = 30;

    public static void main(String[] args) {
        DaemonStarter.startDaemon((String)DAEMON_NAME, (IDaemonLifecycleListener)new ServerStarter());
    }

    protected void doBeforeSpringStart() {
        AdditionalJavaPropsStore.addProperty("hz.group.name", DaemonStarter.getDaemonProperties().getProperty(CLOUDCONDUCTOR_URL));
        AdditionalJavaPropsStore.addProperty("hz.host", DaemonStarter.getDaemonProperties().getProperty(HAZELCAST_MEMBERS));
        if (DaemonStarter.isDevelopmentMode()) {
            Logger.getLogger((String)"de.cinovo.cloudconductor.server").setLevel(Level.DEBUG);
        }
        Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"org.apache.velocity");
        super.doBeforeSpringStart();
    }

    protected void doAfterSpringStart() {
        CleanUpTask cleanup = (CleanUpTask)this.getContext().getBean("cleanuptask", CleanUpTask.class);
        ses.scheduleAtFixedRate(cleanup, 0L, 30L, TimeUnit.MINUTES);
        super.doAfterSpringStart();
    }

    public void exception(LifecyclePhase phase, Throwable exception) {
        log.error((Object)String.format(EXCEPTION_IN_PHASE, phase.name()), exception);
    }

    public IPropertyProvider getPropertyProvider() {
        return new FilePropertyProvider(CLOUDCONDUCTOR_PROPERTIES);
    }
}

